#include "audio.h"

ALLEGRO_SAMPLE_INSTANCE* Audio::activeBgmInstance;
std::vector<ALLEGRO_SAMPLE_INSTANCE*> Audio::activeSfxInstances;

ALLEGRO_SAMPLE* Audio::titleBgm;
ALLEGRO_SAMPLE* Audio::s1s2Bgm;
ALLEGRO_SAMPLE* Audio::s3Bgm;

ALLEGRO_SAMPLE* Audio::fireTransient0;
ALLEGRO_SAMPLE* Audio::firePersistent0;
ALLEGRO_SAMPLE* Audio::pcHit0;

ALLEGRO_SAMPLE* Audio::uiSelect0;
ALLEGRO_SAMPLE* Audio::explosion[NUM_EXPLOSIONS];

ALLEGRO_SAMPLE* Audio::multiplierAdvance0;
ALLEGRO_SAMPLE* Audio::warning0;
ALLEGRO_SAMPLE* Audio::edgeAlert0;

ALLEGRO_SAMPLE* Audio::pickup0;

ALLEGRO_SAMPLE* Audio::boost0;

float Audio::bgmGain;
float Audio::sfxGain;

void Audio::Initialize()
{
    al_install_audio();
    al_init_acodec_addon();

    LoadResources();

    SetBgmGain(0.5);
    SetSfxGain(0.5);

    activeBgmInstance = nullptr;
}

void Audio::Uninitialize()
{
    for(std::vector<ALLEGRO_SAMPLE_INSTANCE*>::iterator it = activeSfxInstances.begin(); it!= activeSfxInstances.end(); ++it)
    {
        al_destroy_sample_instance(*it);
    }
    activeSfxInstances.clear();

    al_destroy_sample_instance(activeBgmInstance);

    UnloadResources();
    al_uninstall_audio();
}

void Audio::LoadResources()
{
    al_reserve_samples(16);

    titleBgm = al_load_sample("Galactic Rap.mp3");
    s1s2Bgm = al_load_sample("Mesmerizing Galaxy Loop.mp3");
    s3Bgm = al_load_sample("Furious Freak.mp3");

    uiSelect0 = al_load_sample("uiSelect0.wav");

    fireTransient0 = al_load_sample("fireTransient0.wav");
    firePersistent0 = al_load_sample("firePersistent0.wav");
    pcHit0 = al_load_sample("pcHit0.wav");

    explosion[0] = al_load_sample("explosion0.wav");
    explosion[1] = al_load_sample("explosion1.wav");
    explosion[2] = al_load_sample("explosion2.wav");
    explosion[3] = al_load_sample("explosion3.wav");
    explosion[4] = al_load_sample("explosion4.wav");
    explosion[5] = al_load_sample("explosion5.wav");
    pickup0 = al_load_sample("pickup0.wav");

    multiplierAdvance0 = al_load_sample("multiplierAdvance0.wav");
    warning0 = al_load_sample("warning0.wav");
    edgeAlert0 = al_load_sample("edgeAlert0.wav");

    boost0 = al_load_sample("boost0.wav");

}

void Audio::UnloadResources()
{
    al_destroy_sample(titleBgm);
    al_destroy_sample(s1s2Bgm);
    al_destroy_sample(s3Bgm);

    al_destroy_sample(uiSelect0);

    al_destroy_sample(firePersistent0);
    al_destroy_sample(fireTransient0);
    al_destroy_sample(pcHit0);

    for(size_t i = 0; i < NUM_EXPLOSIONS; i++)
        al_destroy_sample(explosion[i]);

    al_destroy_sample(pickup0);

    al_destroy_sample(multiplierAdvance0);
    al_destroy_sample(warning0);
    al_destroy_sample(edgeAlert0);

    al_destroy_sample(boost0);
}

void Audio::SetBgmGain(float gain)
{
    bgmGain = gain;
    if(activeBgmInstance != nullptr)
    {
        al_set_sample_instance_gain(activeBgmInstance, bgmGain);
    }
}

void Audio::SetSfxGain(float gain)
{
    sfxGain = gain;
}

void Audio::AddSfx(ALLEGRO_SAMPLE*  whichSfx)
{
    ALLEGRO_SAMPLE_INSTANCE*sfx;
    sfx = al_create_sample_instance(whichSfx);
    al_set_sample_instance_gain(sfx, Audio::sfxGain);

    al_attach_sample_instance_to_mixer(sfx, al_get_default_mixer());
    Audio::activeSfxInstances.push_back(sfx);
    al_play_sample_instance(sfx);
}

void Audio::SetActiveBgm(ALLEGRO_SAMPLE* whichBgm, unsigned int position_secs)
{
    if(activeBgmInstance != nullptr)
    {
        al_detach_sample_instance(activeBgmInstance);
        al_destroy_sample_instance(activeBgmInstance);
    }

    activeBgmInstance = al_create_sample_instance(whichBgm);
    al_set_sample_instance_playmode(activeBgmInstance, ALLEGRO_PLAYMODE_LOOP);
    al_set_sample_instance_gain(activeBgmInstance, bgmGain);
    al_set_sample_instance_position(activeBgmInstance, al_get_sample_instance_frequency(activeBgmInstance)*position_secs);
    al_attach_sample_instance_to_mixer(activeBgmInstance, al_get_default_mixer());
    al_play_sample_instance(activeBgmInstance);

}

void Audio::Logic()
{
    for(std::vector<ALLEGRO_SAMPLE_INSTANCE*>::iterator it = activeSfxInstances.begin(); it != activeSfxInstances.end();)
    {
        if(!al_get_sample_instance_playing(*it))
        {
            al_detach_sample_instance(*it);
            al_destroy_sample_instance(*it);
            it = activeSfxInstances.erase(it);
        }
        else
        {
            ++it;
        }
    }

}
