#include "actor.h"

Actor::Actor()
{

}

Actor::~Actor()
{

}

void Actor::Initialize()
{
    SetIsActive(true);
    SetIsAlive(true);
    SetIsInBounds(true);
    //SetIsVisible(true);
    //SetIsCollidable(true);
    //SetWasMoved(false);

    SetAllXYPositions(0,0);

    SetMoveSpeed(0.0);
    SetMoveAngle(0.0);

    SetSpriteDimensions(Tile::WIDTH,Tile::HEIGHT);
    SetAllSpriteRotations(GetMoveAngle());
    SetHitboxXYOffset(0,0);
    SetHitboxDimensions(0,0);

    spawnOutOfBoundsCheckDelay = DEFAULT_SPAWN_OUT_OF_BOUNDS_CHECK_DELAY;

    SetCurrentFrame(0);
    SetNumFrames(0);
    SetCurrentFrameDelay(0);
    SetMaxFrameDelay(DEFAULT_MAX_FRAME_DELAY);
}

void Actor::Logic()
{
    if(spawnOutOfBoundsCheckDelay <= 0)
    {
        if(GetXPosition() + GetSpriteWidth()/2 < 0 ||
                GetXPosition() - GetSpriteWidth()/2 > Arena::WIDTH ||
                GetYPosition() + GetSpriteHeight()/2 < 0 ||
                GetYPosition() - GetSpriteHeight()/2 > Arena::HEIGHT)
            SetIsInBounds(false);
    }
    else
        spawnOutOfBoundsCheckDelay --;


    currentFrameDelay ++;
    if(currentFrameDelay > maxFrameDelay)
    {
        currentFrameDelay = 0;
        currentFrame ++;
        if(currentFrame > numFrames-1) // Note that the number of frames is going to be the last frame's index + 1
        {
            currentFrame = 0;
        }
    }

}

void Actor::UpdateInterpolation()
{
    SetInterpolatedXYPosition(GetPreviousXPosition()*(1.0 - Timer::interpolationFactor) + GetXPosition()*Timer::interpolationFactor,
                              GetPreviousYPosition()*(1.0 - Timer::interpolationFactor) + GetYPosition()*Timer::interpolationFactor);
    SetPreviousXYPosition(GetXPosition(), GetYPosition());

    SetInterpolatedSpriteRotation(GetPreviousSpriteRotation()*(1.0 - Timer::interpolationFactor) + GetSpriteRotation()*Timer::interpolationFactor);
    SetPreviousSpriteRotation(GetSpriteRotation());
}
