#ifndef TITLE_H_INCLUDED
#define TITLE_H_INCLUDED

#include "keyboard.h"
#include "display.h"

#include "image.h"
#include "audio.h"
#include "font.h"

#include "scene.h"

#include "palette.h"
#include "hax.h"

#include <string>
#include <map>

struct Title
{
    static inline const std::string titleText = "Antibody";
    static const int TITLE_TEXT_X = Display::WIDTH/2;
    static const int TITLE_TEXT_Y = Display::HEIGHT*2/10; // Font::TEXT_HEIGHT_32;

    enum enumOptions
    {
        OPTION_LAUNCH = 0,
        //OPTION_ARCHIVE = 1,
        OPTION_SETTINGS = 1,
        OPTION_EXIT = 2
    };
    static const int FIRST_OPTION = OPTION_LAUNCH;
    static const int LAST_OPTION = OPTION_EXIT;
    static const int NUM_OPTIONS = LAST_OPTION + 1;

    static const inline std::map<int, std::string> optionStrings =
    {
        {OPTION_LAUNCH, "Launch"},
        //{OPTION_ARCHIVE, "Archive"},
        {OPTION_SETTINGS, "Settings"},
        {OPTION_EXIT, "Exit"}
    };

    static int optionTextX[NUM_OPTIONS];
    static const int OPTION_TEXT_X_BASE = Display::WIDTH/2;

    static int optionTextY[NUM_OPTIONS];
    static const int OPTION_TEXT_Y_SPACING = Font::TEXT_HEIGHT_64;
    static const int OPTION_TEXT_Y_BASE = Display::HEIGHT - (NUM_OPTIONS)*OPTION_TEXT_Y_SPACING;

    static float optionMarkerLeftX, optionMarkerRightX;
    static constexpr float OPTION_MARKER_SPRITE_WIDTH = 16;
    static constexpr float OPTION_MARKER_SPRITE_X_SPACING = 8;

    static int targetedOption;
    static bool exitOptionSelected;

    static void Initialize();

    static void Logic();
    static void Input();
    static void Drawing();

    static void RecalculateOptionMarkerX();

    static void AdjustTargetedOptionUp();
    static void AdjustTargetedOptionDown();
    static void SetTargetedOption(int whichOption);
};

#endif // TITLE_H_INCLUDED
