#ifndef TIMER_H_INCLUDED
#define TIMER_H_INCLUDED

#include <allegro5/allegro5.h>

struct Timer
{
    static constexpr double LPS = 60.0; // Governs the speed and duration of things, so be careful about changing LPS
    static constexpr double LOGIC_TICK_PERIOD = 1.0 / LPS;

    static double interpolationFactor;

    static double maxFPSSetting; // Set by user in settings
    static double maxFrameDuration;

    static void Initialize();
    static void Uninitialize();

    static void UpdateInterpolationFactor(double f){interpolationFactor = f;}

};

#endif // TIMER_H_INCLUDED
