#ifndef SUBSHIP_H_INCLUDED
#define SUBSHIP_H_INCLUDED

#include "image.h"

#include "shipIndex.h"

#include "ship.h"
#include "emitter.h"
#include "particle.h"

#include <cmath>

class Subship : public Ship
{
    int attachmentType {}; // Should use SetAttachmentType() instead of setting directly.
    bool attachmentIsRighthand {}; // Should use SetAttachmentType() instead of setting directly.

    Ship* attachedShip;

    float attachmentRotationOffset{};
    float attachmentXOffset{};
    float attachmentYOffset{};

public:

    Subship();
    ~Subship();

    void Initialize(int hull_type, Ship *attached_ship, bool isRighthand);

    void Logic();

    void Drawing();

    int GetAttachmentType() const { return attachmentType;}

    void SetAttachmentType(int attachment_type)
    {
        attachmentType = attachment_type;

        attachmentRotationOffset = ShipIndex::subshipFormationRotationOffset.at(attachmentType);

        SetAttachmentXYOffset(ShipIndex::subshipAttachmentOffset.at(attachmentType).first,
                              ShipIndex::subshipAttachmentOffset.at(attachmentType).second);

        if(attachmentIsRighthand)
        {
            attachmentXOffset *= -1;
        }

    }
    void SetAttachmentType(int attachment_type, bool is_righthand)
    {
        attachmentIsRighthand = is_righthand;
        SetAttachmentType(attachment_type);
    }

    float GetAttachmentXOffset() const { return attachmentXOffset; }
    void SetAttachmentXOffset(float x){ attachmentXOffset = x;}
    float GetAttachmentYOffset() const { return attachmentYOffset; }
    void SetAttachmentYOffset(float y){ attachmentYOffset = y;}
    void SetAttachmentXYOffset(float x, float y){ SetAttachmentXOffset(x); SetAttachmentYOffset(y);}

    Ship* GetAttachedShip(){return attachedShip;}
    void SetAttachedShip(Ship* attach){attachedShip = attach;}

};

#endif // SUBSHIP_H_INCLUDED
