#pragma once

#include "timer.h"

#include "pc.h"
#include "npc.h"

#include "arena.h"
#include "frame.h"
#include "grid.h"

#include <map>


struct Stage
{
    static int sectionNumber;
    static int sectionLength;
    static int sectionProgress; // in ticks elasped.
    static bool inIntermission;
    static bool inFinalIntermission;

    static const int INTERMISSION_HEADER_X = Display::WIDTH  * 5/10;
    static const int INTERMISSION_LABEL_X = Display::WIDTH * 6/10;
    static const int INTERMISSION_HEADER_Y = Display::HEIGHT * 2/10;
    static const int INTERMISSION_CRAFT_DESTROYED_LABEL_Y = Display::HEIGHT * 4/10;
    static const int INTERMISSION_DAMAGE_RECEIVED_LABEL_Y = Display::HEIGHT * 5/10;
    static const int INTERMISSION_CHAIN_UPTIME_LABEL_Y = Display::HEIGHT * 6/10;
    static const int FINAL_INTERMISSION_FOOTER_X = INTERMISSION_HEADER_X;
    static const int FINAL_INTERMISSION_FOOTER_Y1 = Display::HEIGHT * 8/10;
    static const int FINAL_INTERMISSION_FOOTER_Y2 = Display::HEIGHT * 9/10;


    static std::multimap<int, NPC*>sectionShipSchedule;
    static std::multimap<int, Particle*>sectionEffectsSchedule;
    static std::multimap<int, int>sectionEventsSchedule;

    static const int EDGE_WARNING_EFFECT_LIFESPAN = Timer::LPS*1.5;

    enum enumStageEvents
    {
        STAGE_EVENT_TUTORIAL = 0,
        STAGE_EVENT_ANTIGEN_WARNING = 1,
        STAGE_EVENT_SCHEHERAZADE_BATTLE_MODE = 2
    };

    static bool bossActive;
    static bool bossDefeated;
    static NPC* p_scheherazade; // Pointer for objectives tracking.

    static void Initialize(int starting_section);
    static void Uninitialize();

    static void Logic();
    static void Drawing();

    static void AddNPC(int whichHullType, float x_pos, float y_pos, float x_dest, float y_dest, int spawn_time);
    static void AddNPC(int whichHullType, float x_pos, float y_pos, float x_dest, float y_dest, int spawn_time, int spawn_firing_delay); // Overrides the default spawn firing delay.
    static void AddEdgeWarning(float x_pos, float y_pos, int spawn_time);
    static void AddStageEvent( int which_event, int spawn_time);
    static void DeleteSectionSchedules();
    static void InitTutorialSection();
    static void InitDebugSection();
    static void InitSection1();
    static void InitSection2();
    static void InitSection3();
};
