#pragma once

#ifndef SHIP_H_INCLUDED
#define SHIP_H_INCLUDED

#include "actor.h"

#include "shipindex.h"

#include "emitter.h"

#include "hax.h"

#include <vector>
#include <cmath>

class Ship : public Actor
{

/// Identity
    int hullType{};

    float currentHP{}, maxHP{};

    bool isAutopilot; // For stage transitions and whatnot. Move toward destination.
    float autopilotFixedSpriteRotation;

    bool hasDestination{}, isAtDestination{};
    float xDestination{}, yDestination{};

    bool onDamageGrace;
    bool onDamageGraceInputBlock;
    int damageGraceTicksRemaining;
    int damageGraceInputBlockTick;

    static const int DAMAGE_GRACE_MAX_INPUT_BLOCK_TICKS = Timer::LPS*0.8;
    static constexpr float DAMAGE_MOVE_STABILIZATION = Timer::LPS * 0.002; // Like viscous drag, friction, brakes, or something like that
    float damageXBounceVelocity; // x component
    float damageYBounceVelocity; // y component

    bool inDeathSequence;
    int deathSequenceTicks;
    int deathSequenceTicksMax;

    int coreOverloadFrame;
    int coreOverloadFrameTick;

    bool hasTrackedTarget{};
    Ship* trackedTarget;

    bool hasTrackedPosition{};
    std::vector<Emitter*> emitters;

    float emitterXOffset{}, emitterYOffset{};

    std::vector<Bullet*>persistentBulletHits {};

    bool canMakeAfterimages {};
    bool isAfterimagesEnabled {};
    //bool isAfterimageBoostMode {}; // Makes afterimages fall at high speed to simulate boost.
    int afterimageFormUsed {}; // Which particle form to create?
    int afterimageTicks {};
    int afterimageTicksRequired {};
    static const int AFTERIMAGE_DEFAULT_TICKS_REQUIRED = Timer::LPS*0.05;
    static const int AFTERIMAGE_LIFESPAN = Timer::LPS*0.20; // Should be some factor of 4 greater than TICKS_REQUIRED, since there are four frames.
                                                            // Also, note that LPS is an integer (60), so LPS needs to divide with no remainder.


public:
    Ship();
    ~Ship();

    void Initialize();
    void Logic();

    void EnableAutopilot(float dest_x, float dest_y, float auto_speed, float fixed_sprite_rotation);
    void DisableAutopilot();

    void ProgressDamageBounce();
    void InitDamageGrace(int duration);
    void InitDeathSequence(int sequence_ticks);
    void InitDamageBounce(float bullet_x, float bullet_y, float velocity);
    void AfterimageUpdate(bool is_flipped_horizontal);

    int GetHullType() const { return hullType; }
    void SetHullType(int whichHullType){ hullType = whichHullType;}

    bool GetIsAutopilot() const {return isAutopilot;}
    float GetAutopilotFixedSpriteRotation() const {return autopilotFixedSpriteRotation;}

    void SetHasDestination(bool b) {hasDestination = b;}
    bool GetHasDestination() const {return hasDestination;}
    void SetIsAtDestination(bool b) {isAtDestination = b;}
    bool GetIsAtDestination() const {return isAtDestination;}
    float GetXDestination() const {return xDestination;}
    void SetXDestination(float x){hasDestination = true; isAtDestination = false; xDestination = x;}
    float GetYDestination() const {return yDestination;}
    void SetYDestination(float y){hasDestination = true; isAtDestination = false; yDestination = y;}
    void SetXYDestination(float x, float y){SetXDestination(x); SetYDestination(y);}

    bool GetOnDamageGrace() const {return onDamageGrace;}
    void SetOnDamageGrace(bool on) {onDamageGrace = on;}
    bool GetOnDamageGraceInputBlock() const {return onDamageGraceInputBlock;}
    void SetOnDamageGraceInputBlock(bool on)  {onDamageGraceInputBlock = on;}
    int GetDamageGraceTicksRemaining() const {return damageGraceTicksRemaining;}
    void SetDamageGraceTicksRemaining(int ticks) { damageGraceTicksRemaining = ticks;}
    float GetDamageXBounceVelocity() const {return damageXBounceVelocity;}
    float GetDamageYBounceVelocity() const {return damageYBounceVelocity;}
    void SetDamageXYBounceVelocity(float x, float y){damageXBounceVelocity = x; damageYBounceVelocity = y;}

    int GetCoreOverloadFrame() const {return coreOverloadFrame;}
    void SetCoreOverloadFrame(int frame){ coreOverloadFrame = frame;}
    void SetCoreOverloadFrameTick(int tick){coreOverloadFrameTick = tick;}

    int GetDeathSequenceTicks() const {return deathSequenceTicks;}
    int GetDeathSequenceTicksMax() const {return deathSequenceTicksMax;}

    bool GetInDeathSequence() const {return inDeathSequence; }

    float GetCurrentHP() const { return currentHP; }
    void SetCurrentHP(int hp){currentHP = hp;}
    float GetMaxHP() const { return maxHP; }
    void SetMaxHP(int hp){currentHP = maxHP = hp;}


    bool GetHasTrackedTarget() const { return hasTrackedTarget; }
    Ship* GetTrackedTarget(){return trackedTarget;}
    void SetTrackedTarget(Ship* target)
    {
        trackedTarget = target;

        if(trackedTarget == nullptr)
            hasTrackedTarget = false;
        else
            hasTrackedTarget = true;
    }

    void AddEmitter(Emitter* emitter){emitters.push_back(emitter);}
    std::vector<Emitter*> &GetEmitterVector(){ return emitters;}
    Emitter* GetEmitter(size_t index){ return emitters[index];}
    void SetEmitterXYOffset(float x, float y){ emitterXOffset = x; emitterYOffset = y;}

    std::vector<Bullet*> &GetPersistentBulletHitsVector(){ return persistentBulletHits; }
    void AddPersistentBulletHits(Bullet* bullet){ persistentBulletHits.push_back(bullet); }

    void EnableAfterimages(int form_index){ isAfterimagesEnabled = true; afterimageTicks = 0; afterimageFormUsed = form_index;}
    void DisableAfterimages(){isAfterimagesEnabled = false;}
    //void SetIsAfterimageBoostMode(bool b){ isAfterimageBoostMode = b;}

};

#endif // SHIP_H_INCLUDED
