#pragma once

#include <allegro5/allegro5.h>
#include <allegro5/shader.h>

#include <iostream>

struct Shader
{
    static ALLEGRO_SHADER *shader;

    static inline const char* vertex_shader_code =

R"(
#version 330

in vec4 al_pos;
in vec4 al_color;
in vec2 al_texcoord;

out vec4 color;
out vec2 texcoord;

void main()
{
    gl_Position = al_pos;
    color = al_color;
    texcoord = al_texcoord;
}
)";

    static inline const char* fragment_shader_code =
R"(
#version 330

uniform sampler2D al_tex;

in vec4 color;
in vec2 texcoord;

out vec4 frag_color;

void main()
{
    //vec4 tex_color = texture2D(al_tex, texcoord);
    //frag_color = tex_color;

    vec4 tex_color = texture2D(al_tex, texcoord) * color;
    if (tex_color.r == 1.0 && tex_color.g == 1.0 && tex_color.b == 1.0)
    {
        frag_color = vec4(0.0, 0.0, 1.0, tex_color.a);
    }
    else
    {
        frag_color = tex_color;
    }
}
)";

    static void Initialize()
    {
/*
        shader = al_create_shader(ALLEGRO_SHADER_GLSL);

        if(! al_attach_shader_source(shader, ALLEGRO_VERTEX_SHADER, vertex_shader_code) )
            std::cout << "Failed to attach shader source -- VERTEX SHADER" << std::endl;
        else
            std::cout << "Attached VERTEX SHADER" << std::endl;

        std::cout << "Shader log:" << al_get_shader_log(shader) << std::endl;

        if(! al_attach_shader_source(shader, ALLEGRO_PIXEL_SHADER, fragment_shader_code) )
            std::cout << "Failed to attach shader source -- FRAGMENT SHADER" << std::endl;
        else
            std::cout << "Attached FRAGMENT SHADER" << std::endl;

        std::cout << "Shader log:" << al_get_shader_log(shader) << std::endl;

        if (!al_build_shader(shader))
            std::cout << "Failed to build shader" << std::endl;
        else
            std::cout << "Built shader " << std::endl;

        std::cout << "Shader log:" << al_get_shader_log(shader) << std::endl;
*/
    }

    static void Uninitialize()
    {
        //al_destroy_shader(shader);
    }
};
