#ifndef SETTINGS_H_INCLUDED
#define SETTINGS_H_INCLUDED

#include "display.h"
#include "keyboard.h"

#include "image.h"
#include "font.h"
#include "audio.h"

#include "scene.h"

#include "palette.h"
#include "hax.h"

#include <string>
#include <iostream>
#include <map>

struct Settings
{
    enum enumOptions
    {
        OPTION_BGM_LEVEL = 0,
        OPTION_SFX_LEVEL = 1,
        OPTION_RETURN_TO_TITLE = 2
    };
    static const int NUM_OPTIONS = 3;
    static const int FIRST_OPTION = OPTION_BGM_LEVEL;
    static const int LAST_OPTION = OPTION_RETURN_TO_TITLE;

    static inline const std::map<int, std::string>optionStrings =
    {
        //{OPTION_FPS_LIMIT, "FPS"},
        //{OPTION_GLOBAL_MUTE, "Mute"},
        {OPTION_BGM_LEVEL, "Music"},
        {OPTION_SFX_LEVEL, "Sound"},
        //{OPTION_DISABLE_BACKGROUND, "Background: "},
        {OPTION_RETURN_TO_TITLE, "Return to Title"}
    };

    static int optionTextX[NUM_OPTIONS];
    static const int OPTION_TEXT_X_BASE = Display::WIDTH * 0.15;

    static int optionTextY[NUM_OPTIONS];
    static const int OPTION_TEXT_Y_BASE = Display::HEIGHT*0.20;
    static const int OPTION_TEXT_Y_SPACING = 64;

    static float optionMarkerLeftX;
    static constexpr float OPTION_MARKER_SPRITE_WIDTH = 64;
    static constexpr float OPTION_MARKER_SPRITE_X_SPACING = 8;

    static int targetedOption;

    static bool audioMuteChecked;

    static int bgmBars;
    static int sfxBars;
    static const int MAX_VOLUME_BARS = 10;
    static constexpr float VOLUME_BARS_X = OPTION_TEXT_X_BASE + 128;
    static constexpr float VOLUME_BAR_WIDTH = 32;
    static float bgmBarsTotalWidth;
    static float sfxBarsTotalWidth;
    static constexpr float VOLUME_BAR_HEIGHT = 64;

    static void Initialize();

    static void Logic();
    static void Input();
    static void Drawing();

    static void RecalculateOptionMarkerX();

    static void AdjustTargetedOptionUp();
    static void AdjustTargetedOptionDown();
    static void SetTargetedOption(int whichOption);

    static void SetBgmBars(int bars);
    static void SetSfxBars(int bars);
};

#endif // SETTINGS_H_INCLUDED
