#ifndef SCORE_H_INCLUDED
#define SCORE_H_INCLUDED

#include <map>
#include <cmath>
#include <iostream>

#include "timer.h"

#include "audio.h"

struct Score
{
	enum enumScoreTier
	{
		SCORE_TIER_POPCORN = 0,
		SCORE_TIER_SMALL_SHIP = 1,
		SCORE_TIER_DRONE = 2,
		SCORE_TIER_LARGE_SHIP = 3,
		SCORE_TIER_MECHA = 4,
		SCORE_TIER_BOSS = 5
	};

	static const inline std::map<int, int> npcDestructionValue
	{
	    {SCORE_TIER_POPCORN,     200},
	    {SCORE_TIER_SMALL_SHIP,  800},
	    {SCORE_TIER_DRONE,       400},
	    {SCORE_TIER_LARGE_SHIP, 2400},
	    {SCORE_TIER_MECHA,      2400},
	    {SCORE_TIER_BOSS,     300000}
	};
	static const int NUM_SCORE_TIERS = 6;

	static int score;

	static int pcHitsReceived; /// Part of stage record

	static const int MULTIPLIER_BASE = 2; // Note that 2^0 = 1
	static int multiplierExponent;
	static const int MAX_MULTIPLIER_EXPONENT = 5;
	static int multiplierValue; // base^exponent = multiplierValue
    static bool isMultiplierOverflowSignal;

    static int npcsDestroyed; /// Part of stage record

    static int comboCounterNumFill;
	static int npcDestructionChain;
	static int recordNpcDestructionChain; /// Part of stage record

	static const int NPC_DESTRUCTIONS_PER_MULTIPLIER_EXPONENT_INCREASE = 4;

	static int npcDestructionIdleLockedTicks;
	static int npcDestructionIdle;
	static const int NPC_DESTRUCTION_RESET_TIME = Timer::LPS*4;

	static bool powerupDropAvailable;
	static int ticksToPowerupDrop;
	static const int REQ_TICKS_TO_POWERUP_DROP = Timer::LPS*15;
	//static const int REQ_TICKS_TO_POWERUP_DROP = Timer::LPS*1;

	static void Initialize();
	static void Logic();

	static void AddNPCDestructionValue(int score_value);
	static void UpdateMultiplier();
	static void PCHitPenalty();

	static void ResetPowerupDrop()
	{
	    powerupDropAvailable = false;
        ticksToPowerupDrop = 0;
        //std::cout << "powerup drop reset" << std::endl;
    }
};


#endif //SCORE_H_INCLUDED
