#pragma once

#include "timer.h"

#include <map>

struct PowerupDropIndex
{
    enum enumEffects
    {
        SPREAD_CANNON = 0,
        UPGRADED_SLASH = 1,
        OVERSHIELD = 2,
        DORU_SUPPORT = 3,

        HYPER_CANNON = 4
    };
    static const int NUM_EFFECTS = 5;

    static const int OVERSHIELD_NUM_FRAMES = 5;

    static const inline std::map<size_t, int>numCharges =
    {
        {SPREAD_CANNON,    Timer::LPS*10},
        {UPGRADED_SLASH,   Timer::LPS*10},
        {OVERSHIELD,       Timer::LPS*6},
        {DORU_SUPPORT,     Timer::LPS*10},
        {HYPER_CANNON,     Timer::LPS*6},
    };

    static const inline std::map<size_t, std::string>powerupNames =
    {
        {SPREAD_CANNON,    "WIDE BLASTER"},
        {UPGRADED_SLASH,   "SWORD BOOST"},
        {OVERSHIELD,       "OVERSHIELD"},
        {DORU_SUPPORT,     "DRONE SUPPORT"},

        {HYPER_CANNON,     "HYPER BEAM"},
    };

};

