#pragma once

#include "powerupdropindex.h"

#include "actor.h"
#include "image.h"

#include <vector>

class PowerupDrop : public Actor
{
    int remainingLifespan;
    const int INITIAL_LIFESPAN = Timer::LPS*10;

    int effect;
    int effectCyclingTicks;
    static const int EFFECT_CYCLING_TICKS_MAX = Timer::LPS*0.25;

    static constexpr float INITIAL_DROP_VELOCITY = -4.0;
    static constexpr float DROP_ACCELERATION = 0.12;
    float dropVelocity;
    static constexpr float MAX_DROP_VELOCITY = 2.5;
    bool reachedPreDropAccelerationMinimumYPosition;
    static constexpr float PRE_DROP_ACCELERATION_MINIMUM_Y_POSITION = Arena::HEIGHT * 0.25; // Can't begin downward acceleration before at least rising to this threshold position.

public:
    static std::vector<PowerupDrop*>powerupDrops;

    PowerupDrop();
    ~PowerupDrop();
    void Initialize(float x, float y);

    void Logic();
    void Drawing();

    int GetEffect() const {return effect;}
};
