#pragma once

#include "ship.h"

#include "shipindex.h"

#include "particle.h"
#include "emitter.h"
#include "subship.h"
#include "powerupdrop.h"

#include "direction.h"
#include "flyingtext.h"

#include "hax.h"

#include <vector>
#include <map>
#include <cmath>
#include <algorithm>

class PC : public Ship
{
    static constexpr float MAX_STEERING_ANGLE = 2*ALLEGRO_PI *0.125;
    float steeringAngleOffset;
    float steeringAngleOffsetDestination; // Correction is toward this angle.
    static constexpr float STEERING_ANGLE_CORRECTION = 2*ALLEGRO_PI * 0.04;  // Rate of change.
    static constexpr float STEERING_ANGLE_NORMALIZATION = STEERING_ANGLE_CORRECTION * 0.4;

    int lives;

    enum enumSubshipFormations
    {
        FORMATION_NEUTRAL,
        FORMATION_XIPHOS_VERTICAL_CROSS,
        FORMATION_XIPHOS_VERTICAL_SLASH,
        FORMATION_XIPHOS_HORIZONTAL_CROSS,
        FORMATION_XIPHOS_HORIZONTAL_SLASH
    };

    int subshipFormation;
    std::vector<Subship*>subships;
    int subshipFormationCurrentFrame;
    static const inline std::map<int, int>subshipFormationMaxFrame
    {
        {FORMATION_NEUTRAL, 0},
        {FORMATION_XIPHOS_VERTICAL_CROSS,   Timer::LPS*0.25},
        {FORMATION_XIPHOS_VERTICAL_SLASH,   Timer::LPS*0.35},
        {FORMATION_XIPHOS_HORIZONTAL_CROSS, Timer::LPS*0.25},
        {FORMATION_XIPHOS_HORIZONTAL_SLASH, Timer::LPS*0.35}
    };
    int subshipFormationNext;

    bool moveInputReceived[Direction::NUM_DIRECTIONS] = {false, false, false, false};

    static const int NUM_FIRE_BUTTONS = 3;
    bool fireInputReceived[NUM_FIRE_BUTTONS] = {false, false, false};

    bool isPowerupActive[PowerupDropIndex::NUM_EFFECTS] = {false, false, false, false, false};
    int powerupNumCharges[PowerupDropIndex::NUM_EFFECTS] = { 0, 0, 0, 0, 0};
    int overshieldFrame;
    int overshieldFrameDelayTicks;
    static const int OVERSHIELD_FRAME_DELAY_MAX = 4;
    float overshieldSpriteRotation;
    static constexpr float OVERSHIELD_HITBOX_X_OFFSET = -80;
    static constexpr float OVERSHIELD_HITBOX_Y_OFFSET = -80;
    static constexpr float OVERSHIELD_HITBOX_WIDTH = 160;
    static constexpr float OVERSHIELD_HITBOX_HEIGHT = 160;


    static const int POWERUP_TIMEOUT_BAR_WIDTH = Tile::WIDTH*2;
    int trackedPowerup; // Because only one can be tracked at a time.

public:
    static PC*pc;

    enum enumPCHulls
    {
        HULL_PC_ORTHOS_A = 0
    };

    PC();
    ~PC();

    void Initialize(int whichHullType);

    void Logic();

    void AddSubship(int hull_preset, bool is_right_handed);
    void ChangeSubshipFormation(int formation);
    int GetSubshipFormation() const {return subshipFormation;}

    void EnablePowerup(size_t index);
    void DisablePowerup(size_t index);

    void MainDrawing();
    void SubshipDrawing();
    void OvershieldDrawing();
    void PowerupTimeoutDrawing();

    bool GetMoveInputReceived(int n) const {return moveInputReceived[n];}
    void SetMoveInputReceived(int n, bool active) {moveInputReceived[n] = active;}

    bool GetFireInputReceived(int n) const { return fireInputReceived[n]; }
    void SetFireInputReceived(int n, bool active){fireInputReceived[n] = active;}
};
