#ifndef PARTICLEINDEX_H_INCLUDED
#define PARTICLEINDEX_H_INCLUDED

#include "tile.h"

struct ParticleIndex
{
    static const int NUM_FRAMES = 4;
    static const int DEFAULT_FRAME_DELAY = Timer::LPS*0.10;

    enum enumParticleForms
    {
        PARTICLE_HIT_BLUE = 0,
        PARTICLE_HIT_BLACK = 1,

        PARTICLE_EXPLODE = 2,

        PARTICLE_EDGE_WARNING = 3,

        PARTICLE_PC_CORE_AFTERIMAGE = 4,
        PARTICLE_SUBSHIP_XIPHOS_AFTERIMAGE = 5,
        PARTICLE_SUBSHIP_DORU_AFTERIMAGE = 6,

        PARTICLE_SCHEHERAZADE_AFTERIMAGE = 7
    };
    static const int FORM_AFTERIMAGE_MARKER_BEGIN = PARTICLE_PC_CORE_AFTERIMAGE;
    static const int FORM_AFTERIMAGE_MARKER_END = PARTICLE_SUBSHIP_XIPHOS_AFTERIMAGE;
    static const int PARTICLE_PNG_MARKER_BEGIN = PARTICLE_HIT_BLUE;
    static const int PARTICLE_PNG_MARKER_END = PARTICLE_SUBSHIP_DORU_AFTERIMAGE;
    static const int PARTICLE_BOSS_AFTERIMAGE_PNG_MARKER_BEGIN = PARTICLE_SCHEHERAZADE_AFTERIMAGE;
    static const int PARTICLE_BOSS_AFTERIMAGE_PNG_MARKER_END = PARTICLE_SCHEHERAZADE_AFTERIMAGE;
    static const int NUM_PARTICLE_FORMS = 8;

};

#endif // PARTICLEINDEX_H_INCLUDED
