#ifndef PARTICLE_H_INCLUDED
#define PARTICLE_H_INCLUDED

#include "actor.h"

#include "timer.h"
#include "image.h"

#include "arena.h"

#include "palette.h"

#include "particleIndex.h"

#include <vector>
#include <cmath>
#include <iostream>

class Particle : public Actor
{
    int lifespanElasped{}, lifespan{};
    static const int BASE_PARTICLE_LIFESPAN = Timer::LPS *0.5;

    int form;
    bool isFlippedHorizontal;

    //bool onAfterimageBoost; // Intended for afterimages, of course.
    //static constexpr float AFTERIMAGE_BOOST_SPEED = 32;

public:
    static std::vector<Particle*> particles;
    static std::vector<Particle*> afterimages;

    Particle();
    ~Particle();

    void Initialize(int form, float speed, float angle, int lifespan);

    void Logic();
    void Drawing();

    void SetLifespan(int cycles)
    {
        lifespanElasped = 0;
        lifespan = cycles;
    }

    int GetForm() const {return form;}
    void SetForm(int whichForm){form = whichForm;}

    bool GetIsFlippedHorizontal() const {return isFlippedHorizontal;}
    void SetIsFlippedHorizontal(bool is_h_flipped){isFlippedHorizontal = is_h_flipped;}

    //void SetOnAfterimageBoost(bool b) {onAfterimageBoost = b;}
};

#endif // BULLET_H_INCLUDED
