#ifndef STAGE_H_INCLUDED
#define STAGE_H_INCLUDED

#include <vector>
#include <string>

#include "keyboard.h"
#include "mouse.h"

#include "image.h"
#include "font.h"
#include "audio.h"

//#include "archive.h"

#include "lives.h"
#include "pc.h"
#include "npc.h"
#include "particle.h"
#include "powerupdrop.h"
#include "stage.h"
#include "score.h"
#include "flyingtext.h"

#include "tile.h"
#include "camera.h"
#include "palette.h"
#include "scene.h"
#include "frame.h"
#include "grid.h"

#include "hax.h"

struct Overworld
{
    static void Initialize();
    static void Uninitialize();

    static void Logic();
    static void Input();
    static void Drawing();

    static void AdvanceGridUnderlay();
    static void DrawGridUnderlay();

    static void Reset();

};

#endif // STAGE_H_INCLUDED
