#ifndef NPC_H_INCLUDED
#define NPC_H_INCLUDED

#include "ship.h"

#include "particle.h"
#include "emitter.h"
#include "powerupdrop.h"
#include "flyingtext.h"

#include "arena.h"
#include "score.h"

#include <cmath>
#include <iostream>
#include <algorithm>

class NPC : public Ship
{
    int scoreValue{};
    static const int MIN_SCORE_VALUE_TO_DROP_POWERUP = 1; // Used to be 200, but I don't feel like it.

    float lastCollidingBulletX, lastCollidingBulletY;

    Ship *shadowedShip;
    float shadowingXDisplacement{}, shadowingYDisplacement{};

    int spawnFiringDelay {};
    static const int DEFAULT_SPAWN_FIRING_DELAY = Timer::LPS * 1.0;

    bool isSelfdestructing {};

    bool hasBossProtocol {};
    int bossProtocolEmitterRandomizationTick;
    static const int BOSS_PROTOCOL_EMITTER_RANDOMIZATION_TICKS_MAX = Timer::LPS*6.0;
    int bossProtocolDamageToQuarterHP;

public:
    static std::vector<NPC*>npcs;

    NPC();
    ~NPC();

    void Initialize(int whichHullType, float x_pos, float y_pos, float x_dest, float y_dest);
    void Uninitialize();

    void Logic();
    void Drawing();

    void EmitDeathSparks();
    void DropPowerup();

    void EnableBossProtocol();

    float GetScoreValue() const { return scoreValue; }
    void SetScoreValue(float score_value) { scoreValue = score_value; }

    void SetShadowedShip(Ship* target){shadowedShip = target;}
    float GetShadowingXDisplacement() const { return shadowingXDisplacement; }
    void SetShadowingXDisplacement(float x){shadowingXDisplacement = x;}
    float GetShadowingYDisplacement() const { return shadowingYDisplacement; }
    void SetShadowingYDisplacement(float y){shadowingYDisplacement = y;}
    void SetShadowingXYDisplacement(float x, float y){SetShadowingXDisplacement(x), SetShadowingYDisplacement(y);}



};

#endif // NPC_H_INCLUDED
