#pragma once

#include <allegro5/allegro5.h>
#include <allegro5/allegro_image.h>
#include <allegro5/allegro_primitives.h>

#include "tile.h"

#include "frameeventindex.h"
#include "shipindex.h"
#include "bulletindex.h"
#include "particleindex.h"
#include "emitterindex.h"
#include "powerupdropindex.h"

#include <iostream>

struct Image
{
    static ALLEGRO_BITMAP *titleOptionMarkerPng;
    static ALLEGRO_BITMAP *settingsVolumeBarPng;
    static ALLEGRO_BITMAP *settingsVolumeBarEmptyPng;

    static ALLEGRO_BITMAP *comboCounterEmptyPng;
    static ALLEGRO_BITMAP *comboCounterPng;
    static ALLEGRO_BITMAP *comboCounterSub[4];

    static ALLEGRO_BITMAP *frameEventWarningCombinedPng;
    static ALLEGRO_BITMAP *frameEventWarningRows[FrameEventIndex::ANTIGEN_WARNING_NUM_ROWS * FrameEventIndex::ANTIGEN_WARNING_NUM_FRAMES];

    static ALLEGRO_BITMAP *pcCorePng;
    static ALLEGRO_BITMAP *pcCoreSub[ShipIndex::PC_CORE_NUM_FRAMES];

    static ALLEGRO_BITMAP *subshipPng;
    static ALLEGRO_BITMAP *subshipSub[ShipIndex::SUBSHIP_HULL_NUM_TYPES * ShipIndex::SUBSHIP_NUM_FRAMES];

    static ALLEGRO_BITMAP *npcShipPng;
    static ALLEGRO_BITMAP *npcShipSub[ShipIndex::HULL_NPC_NUM_TYPES];

    static ALLEGRO_BITMAP *coreOverloadPng;
    static ALLEGRO_BITMAP *coreOverloadSub[ShipIndex::NUM_CORE_OVERLOAD_FRAMES];

    static ALLEGRO_BITMAP *bulletMainDarkPng;
    static ALLEGRO_BITMAP *bulletSlashPng;
    static ALLEGRO_BITMAP *bulletSub[BulletIndex::NUM_ALL_SHAPES * BulletIndex::NUM_FRAMES];

    static ALLEGRO_BITMAP *particlePng;
    static ALLEGRO_BITMAP *scheherazadeAfterimagePng;
    static ALLEGRO_BITMAP *particleSub[ParticleIndex::NUM_PARTICLE_FORMS * ParticleIndex::NUM_FRAMES];

    static ALLEGRO_BITMAP *powerupDropPng;
    static ALLEGRO_BITMAP *powerupDropSub[PowerupDropIndex::NUM_EFFECTS];

    static ALLEGRO_BITMAP *overshieldPng;
    static ALLEGRO_BITMAP *overshieldSub[PowerupDropIndex::OVERSHIELD_NUM_FRAMES];

    static ALLEGRO_BITMAP *emitterTelegraphPng;
    static ALLEGRO_BITMAP *emitterTelegraphSub[EmitterIndex::NUM_EMITTER_TELEGRAPH_FRAMES * EmitterIndex::NUM_EMITTER_TELEGRAPH_COLOURS];

    static void Initialize();
    static void Uninitialize();

    static void LoadResources();
    static void UnloadResources();
};
