#pragma once

#include <allegro5/allegro5.h>
#include <allegro5/allegro_primitives.h>

#include "tile.h"
#include "arena.h"

#include "timer.h"

#include "palette.h"

#include <cmath>

struct Grid
{
    static constexpr float GRID_LINE_SEPARATION = Tile::WIDTH;
    static constexpr float GRID_NUM_COLUMNS = 11;
    static constexpr float GRID_NUM_ROWS = 5;
    static constexpr float GRID_SCROLL_Y_SPEED_DEFAULT = 8.0;
    static float gridScrollYSpeed;
    static float gridScrollPhase;
    static float gridScrollX;
    static float previousGridScrollX;
    static float interpolatedGridScrollX;
    static float gridScrollY;
    static float previousGridScrollY;
    static float interpolatedGridScrollY;

    static constexpr float DARK_GRID_LINE_SEPARATION = Tile::WIDTH*2;
    static constexpr float DARK_GRID_NUM_COLUMNS = 11;
    static constexpr float DARK_GRID_NUM_ROWS = 5;
    static constexpr float DARK_GRID_SCROLL_Y_SPEED_DEFAULT = 2.0;
    static float darkGridScrollYSpeed;
    static float darkGridScrollPhase;
    static float darkGridScrollX;
    static float previousDarkGridScrollX;
    static float interpolatedDarkGridScrollX;
    static float darkGridScrollY;
    static float previousDarkGridScrollY;
    static float interpolatedDarkGridScrollY;

    static void Initialize();
    static void Logic();
    static void Drawing();
};


