#pragma once

#include "image.h"
#include "audio.h"
#include "font.h"
#include "palette.h"

#include "score.h"
#include "pc.h"
#include "subship.h"

#include "arena.h"
#include "tile.h"

#include "hax.h"

#include <string>
#include <sstream>
#include <iomanip>

struct Frame
{
    static constexpr float ARENA_HEIGHT = Arena::HEIGHT;

    static constexpr float COMBO_COUNTER_X = 0; // To be drawn centered using al_rotated_sprite, so the real X/Y will be less half the WIDTH/HEIGHT specified below.
    static constexpr float COMBO_COUNTER_Y = 0;
    static constexpr float COMBO_COUNTER_WIDTH = 64;
    static constexpr float COMBO_COUNTER_HEIGHT = 64;
    static float comboCounterNumFills;
    static float comboCounterRotation;
    static constexpr float COMBO_COUNTER_ROTATION_RATE = 2*ALLEGRO_PI / (Timer::LPS*12);
    static int comboMultiplier; // Note that this is not Score::multiplierValue;

    static bool isComboCounterFlashing;
    static bool isComboCounterFlashVisible;
    static const int COMBO_COUNTER_NUM_FLASHES = 10;
    static int comboCounterCurrentFlash;
    static const int COMBO_COUNTER_FLASH_NUM_TICKS = Timer::LPS*0.10;
    static int comboCounterFlashCurrentTick;


    static const int SCORE_READOUT_X = COMBO_COUNTER_X + COMBO_COUNTER_WIDTH  + Tile::WIDTH*0 + COMBO_COUNTER_WIDTH/4;
    static const int SCORE_READOUT_Y = Tile::HEIGHT*0;
    static int score; // Note that this is not Score::score, but an intermediate variable to be converted to string.
    static std::string scoreString;

    static constexpr float COMBO_READOUT_X = SCORE_READOUT_X;
    static constexpr float COMBO_READOUT_Y = SCORE_READOUT_Y + Font::TEXT_HEIGHT_32 + 8; // Let's say +8 pixels to keep the score and combo readout text lines from sticking together.
    static std::string comboMultiplierString;

    static constexpr float COMBO_TIMEOUT_BAR_X = COMBO_READOUT_X;
    static constexpr float COMBO_TIMEOUT_BAR_Y = COMBO_READOUT_Y;
    static constexpr float COMBO_TIMEOUT_BAR_FULL_WIDTH = 216;
    static constexpr float COMBO_TIMEOUT_BAR_HEIGHT = 32;
    static constexpr float COMBO_TIMEOUT_BAR_SQUASH = 8;
    static float comboTimeoutBarWidth;

    static constexpr int LIVES_READOUT_X = 0;
    static constexpr int LIVES_READOUT_Y = 0;

    static bool isTutorialActive;
    static bool isCannonTutorialPassed;
    static bool isForwardSlashTutorialPassed;
    static bool isHorizontalSlashTutorialPassed;
    static int tutorialDisengageDelayTicks;

    static bool isAntigenWarningActive;
    static int antigenWarningPhase;
    static int antigenWarningPhaseTicks;
    static int antigenWarningFrame;
    static float antigenWarningXPosition [FrameEventIndex::ANTIGEN_WARNING_NUM_ROWS];

    static void Initialize();

    static void Logic();
    static void Drawing();

    static void UpdateScoreString(int score);
    static void UpdateComboMultiplierString(int multiplier);

    static void InitTutorialFrameEvent();
    static void InitAntigenWarningFrameEvent();
};
