#ifndef FONT_H_INCLUDED
#define FONT_H_INCLUDED

#include <allegro5/allegro_font.h>
#include <allegro5/allegro_ttf.h>

#define FONTDEF_TITLE_TEXT                       Font::monogram128
#define FONTDEF_TITLE_OPTIONS                    Font::monogram64

#define FONTDEF_SETTINGS_OPTION_LABEL            Font::monogram64
#define FONTDEF_SETTINGS_OPTION_VALUE            Font::monogram64

#define FONTDEF_ARCHIVE_TEXT                     Font::monogram32

#define FONTDEF_COMBO_MULTIPLIER_VALUE           Font::monogram32
#define FONTDEF_SCORE_VALUE                      Font::monogram64

#define FONTDEF_FLYINGTEXT_SCORE                 Font::monogram64

#define FONTDEF_FLYINGTEXT_POWERUP_NAME          Font::monogram64

#define FONTDEF_TIMEOUT_BAR_POWERUP_NAME         Font::monogram32

#define FONTDEF_INTERMISSION_HEADER              Font::monogram64
#define FONTDEF_INTERMISSION_LABEL               Font::monogram32
#define FONTDEF_INTERMISSION_VALUE               Font::monogram32

struct Font
{
    static const int TEXT_HEIGHT_32 = 32;
    static const int TEXT_HEIGHT_48 = 48;
    static const int TEXT_HEIGHT_64 = 64;
    static const int TEXT_HEIGHT_128 = 128;

    static ALLEGRO_FONT *monogram32;
    static ALLEGRO_FONT *monogram64;
    static ALLEGRO_FONT *monogram128;

    static void Initialize();
    static void Uninitialize();

    static void LoadResources();
    static void UnloadResources();
};

#endif // FONT_H_INCLUDED
