#ifndef FLYINGTEXT_H
#define FLYINGTEXT_H

#include <string>
#include <vector>

#include "font.h"

#include "timer.h"
#include "palette.h"

#include "arena.h"

#include "hax.h"

class FlyingText
{
	bool isActive{};
	int lifespan{};
	static const int BASE_LIFESPAN = Timer::LPS*1.5;

	std::string text;
	ALLEGRO_FONT *textFont;

	int colourCycleIndex{};
	const int COLOUR_CYCLE_INDEX_BEGIN = Palette::EULBINK_MARKER_BEGIN;
	const int COLOUR_CYCLE_INDEX_END = Palette::EULBINK_MARKER_END;

	int colourCycleDelayCount {};
	const int COLOUR_CYCLE_DELAY_THRESHOLD = 5;

	int xPosition{}; // Final drawing coords to be cast to int
	int yPosition{};
	float yDestination{};
    float yVelocity{};

	static constexpr float Y_TARGET_OFFSET = -32;
	static constexpr float Y_BASE_VELOCITY = Y_TARGET_OFFSET / (Timer::LPS*0.20);

public:
	static std::vector<FlyingText*>flyingTexts;

	FlyingText();
	~FlyingText();

	void Initialize(std::string text_content, ALLEGRO_FONT* text_font, int x_position, int y_position);

	void Logic();
	void Drawing();

	bool GetIsActive() const { return isActive; }
	void SetIsActive(bool active) { isActive = active; }


};

#endif // FLYINGTEXT_H
