#pragma once

#include "bulletindex.h"

struct EmitterIndex
{
    enum telegraphColours
    {
        TELEGRAPH_COLOUR_BLACK = 0,
        TELEGRAPH_COLOUR_BLUE = 1
    };
    static const size_t NUM_EMITTER_TELEGRAPH_COLOURS = 2;
    static const size_t NUM_EMITTER_TELEGRAPH_FRAMES = 3;

    enum enumEmitterPresets
    {
        EMITTER_PRESET_PC_MAIN = 0,
        EMITTER_PRESET_PC_FORWARD_SLASH = 1,
        EMITTER_PRESET_PC_SIDE_SLASH = 2,

        EMITTER_PRESET_PC_SPREAD_CANNON = 3,
        EMITTER_PRESET_PC_HYPER_CANNON = 4,
        EMITTER_PRESET_PC_UPGRADED_FORWARD_SLASH = 5,
        EMITTER_PRESET_PC_UPGRADED_SIDE_SLASH = 6,

        EMITTER_PRESET_DORU_MAIN = 7,

        EMITTER_PRESET_RAY_MAIN = 8,
        EMITTER_PRESET_OCELLUS_MAIN = 9,
        EMITTER_PRESET_ANGELFISH_MAIN = 10,
        EMITTER_PRESET_ANTLION_MAIN = 11,

        EMITTER_PRESET_DISCUS_MAIN = 12,
        EMITTER_PRESET_CONSTANT_SELFDESTRUCT = 13,
        EMITTER_PRESET_CROSS_MAIN = 14,
        EMITTER_PRESET_MISSILE_SELFDESTRUCT = 15,

        EMITTER_PRESET_PARTISAN_SUPPRESSION = 16,
        EMITTER_PRESET_PARTISAN_PERSISTENT = 17,

        EMITTER_PRESET_SUNFISH_MAIN = 18,

        EMITTER_PRESET_SPIRIT_MAIN = 19,

        EMITTER_PRESET_AEGIS_SUPPRESSION = 20,
        EMITTER_PRESET_AEGIS_LASER = 21,

        EMITTER_PRESET_LUNARIAN_SUPPRESSION,
        EMITTER_PRESET_LUNARIAN_SWORD,

        EMITTER_PRESET_SCHEHERAZADE_SUPPRESSION,
        EMITTER_PRESET_SCHEHERAZADE_DIRECTED,
        EMITTER_PRESET_SCHEHERAZADE_SWORD,
        EMITTER_PRESET_SCHEHERAZADE_LASER,
        EMITTER_PRESET_SCHEHERAZADE_METEOR_RAIN,
        EMITTER_PRESET_SCHEHERAZADE_SUN
    };

    static inline const std::map<int, int> emitterBulletPreset =
    {
        {EMITTER_PRESET_PC_MAIN,                   BulletIndex::BULLET_PRESET_PC_ARROW},
        {EMITTER_PRESET_PC_FORWARD_SLASH,          BulletIndex::BULLET_PRESET_PC_FORWARD_SLASH},
        {EMITTER_PRESET_PC_SIDE_SLASH,             BulletIndex::BULLET_PRESET_PC_SIDE_SLASH},

        {EMITTER_PRESET_PC_SPREAD_CANNON,          BulletIndex::BULLET_PRESET_PC_ARROW},
        {EMITTER_PRESET_PC_HYPER_CANNON,           BulletIndex::BULLET_PRESET_PC_LARGE_STAR_DARK},
        {EMITTER_PRESET_PC_UPGRADED_FORWARD_SLASH, BulletIndex::BULLET_PRESET_PC_FORWARD_SLASH},
        {EMITTER_PRESET_PC_UPGRADED_SIDE_SLASH,    BulletIndex::BULLET_PRESET_PC_SIDE_SLASH},

        {EMITTER_PRESET_DORU_MAIN,                 BulletIndex::BULLET_PRESET_PC_ARROW},

        {EMITTER_PRESET_RAY_MAIN,                  BulletIndex::BULLET_PRESET_RAY_ARROW},
        {EMITTER_PRESET_OCELLUS_MAIN,              BulletIndex::BULLET_PRESET_OCELLUS_SPHERE},
        {EMITTER_PRESET_ANGELFISH_MAIN,            BulletIndex::BULLET_PRESET_ANGELFISH_PELLET},
        {EMITTER_PRESET_ANTLION_MAIN,              BulletIndex::BULLET_PRESET_ANTLION_LARGE_STAR},

        {EMITTER_PRESET_DISCUS_MAIN,               BulletIndex::BULLET_PRESET_DISCUS_PELLET},
        {EMITTER_PRESET_CONSTANT_SELFDESTRUCT,     BulletIndex::BULLET_PRESET_CONSTANT_SPHERE},
        {EMITTER_PRESET_CROSS_MAIN,                BulletIndex::BULLET_PRESET_CROSS_ARROW},
        {EMITTER_PRESET_MISSILE_SELFDESTRUCT,      BulletIndex::BULLET_PRESET_MISSILE_PELLET},

        {EMITTER_PRESET_PARTISAN_SUPPRESSION,      BulletIndex::BULLET_PRESET_PARTISAN_ARROW},
        {EMITTER_PRESET_PARTISAN_PERSISTENT,       BulletIndex::BULLET_PRESET_PARTISAN_ARROW_DARK},

        {EMITTER_PRESET_SUNFISH_MAIN,              BulletIndex::BULLET_PRESET_SUNFISH_PELLET},

        {EMITTER_PRESET_SPIRIT_MAIN,               BulletIndex::BULLET_PRESET_SPIRIT_SPHERE},

        {EMITTER_PRESET_AEGIS_SUPPRESSION,         BulletIndex::BULLET_PRESET_AEGIS_PELLET},
        {EMITTER_PRESET_AEGIS_LASER,               BulletIndex::BULLET_PRESET_AEGIS_LARGE_STAR_DARK},
    };

    static inline const std::map<int, bool> emitterWillLockTrackedPosition =
    {
        {EMITTER_PRESET_PC_MAIN,                   false},
        {EMITTER_PRESET_PC_FORWARD_SLASH,          false},
        {EMITTER_PRESET_PC_SIDE_SLASH,             false},

        {EMITTER_PRESET_PC_SPREAD_CANNON,          false},
        {EMITTER_PRESET_PC_HYPER_CANNON,           false},
        {EMITTER_PRESET_PC_UPGRADED_FORWARD_SLASH, false},
        {EMITTER_PRESET_PC_UPGRADED_SIDE_SLASH,    false},

        {EMITTER_PRESET_DORU_MAIN,                 false},

        {EMITTER_PRESET_RAY_MAIN,                  false},
        {EMITTER_PRESET_OCELLUS_MAIN,              false},
        {EMITTER_PRESET_ANGELFISH_MAIN,            false},
        {EMITTER_PRESET_ANTLION_MAIN,              false},

        {EMITTER_PRESET_DISCUS_MAIN,               false},
        {EMITTER_PRESET_CONSTANT_SELFDESTRUCT,     false},
        {EMITTER_PRESET_CROSS_MAIN,                false},
        {EMITTER_PRESET_MISSILE_SELFDESTRUCT,      false},

        {EMITTER_PRESET_PARTISAN_SUPPRESSION,      false},
        {EMITTER_PRESET_PARTISAN_PERSISTENT,       true},
        {EMITTER_PRESET_SUNFISH_MAIN,              false},
        {EMITTER_PRESET_SPIRIT_MAIN,               false},
        {EMITTER_PRESET_AEGIS_SUPPRESSION,         false},
        {EMITTER_PRESET_AEGIS_LASER,               true}
    };

    static inline const std::map<int, unsigned> emitterVolleySize =
    {
        {EMITTER_PRESET_PC_MAIN,                   1},
        {EMITTER_PRESET_PC_FORWARD_SLASH,          1},
        {EMITTER_PRESET_PC_SIDE_SLASH,             1},

        {EMITTER_PRESET_PC_SPREAD_CANNON,          3},
        {EMITTER_PRESET_PC_HYPER_CANNON,           1},
        {EMITTER_PRESET_PC_UPGRADED_FORWARD_SLASH, 3},
        {EMITTER_PRESET_PC_UPGRADED_SIDE_SLASH,    2},

        {EMITTER_PRESET_DORU_MAIN,                 1},

        {EMITTER_PRESET_RAY_MAIN,                  3},
        {EMITTER_PRESET_OCELLUS_MAIN,              1},
        {EMITTER_PRESET_ANGELFISH_MAIN,            5},
        {EMITTER_PRESET_ANTLION_MAIN,              1},

        {EMITTER_PRESET_DISCUS_MAIN,               1},
        {EMITTER_PRESET_CONSTANT_SELFDESTRUCT,    12},
        {EMITTER_PRESET_CROSS_MAIN,                4},
        {EMITTER_PRESET_MISSILE_SELFDESTRUCT,     12},

        {EMITTER_PRESET_PARTISAN_SUPPRESSION,      4},
        {EMITTER_PRESET_PARTISAN_PERSISTENT,       3},
        {EMITTER_PRESET_SUNFISH_MAIN,              6},
        {EMITTER_PRESET_SPIRIT_MAIN,               8},
        {EMITTER_PRESET_AEGIS_SUPPRESSION,         4},
        {EMITTER_PRESET_AEGIS_LASER,               1},

    };

    static inline const std::map<int, float> emitterArcWidth =
    {
        {EMITTER_PRESET_PC_MAIN,                 0.0},
        {EMITTER_PRESET_PC_FORWARD_SLASH,        0.0},
        {EMITTER_PRESET_PC_SIDE_SLASH,           0.0},

        {EMITTER_PRESET_PC_SPREAD_CANNON,          2*ALLEGRO_PI * 0.33},
        {EMITTER_PRESET_PC_HYPER_CANNON,           0.0},
        {EMITTER_PRESET_PC_UPGRADED_FORWARD_SLASH, 2*ALLEGRO_PI * 0.5},
        {EMITTER_PRESET_PC_UPGRADED_SIDE_SLASH,    2*ALLEGRO_PI * 0.20},

        {EMITTER_PRESET_DORU_MAIN,               0.0},

        {EMITTER_PRESET_RAY_MAIN,                2*ALLEGRO_PI * 0.33},
        {EMITTER_PRESET_OCELLUS_MAIN,            0.0},
        {EMITTER_PRESET_ANGELFISH_MAIN,          2*ALLEGRO_PI * 0.999},
        {EMITTER_PRESET_ANTLION_MAIN,            0.0},

        {EMITTER_PRESET_DISCUS_MAIN,             0.0},
        {EMITTER_PRESET_CONSTANT_SELFDESTRUCT,   2*ALLEGRO_PI * 0.999},
        {EMITTER_PRESET_CROSS_MAIN,              2*ALLEGRO_PI * 0.999},
        {EMITTER_PRESET_MISSILE_SELFDESTRUCT,    2*ALLEGRO_PI * 0.999},

        {EMITTER_PRESET_PARTISAN_SUPPRESSION,    2*ALLEGRO_PI * 0.50},
        {EMITTER_PRESET_PARTISAN_PERSISTENT,     2*ALLEGRO_PI * 0.33},

        {EMITTER_PRESET_SUNFISH_MAIN,            2*ALLEGRO_PI * 0.999},
        {EMITTER_PRESET_SPIRIT_MAIN,             2*ALLEGRO_PI * 0.999},
        {EMITTER_PRESET_AEGIS_SUPPRESSION,       2*ALLEGRO_PI * 0.75},
        {EMITTER_PRESET_AEGIS_LASER,             0.0},
    };

    enum enumVolleyRepeatDataLabels
    {
        LABEL_NUM_VOLLEYS = 0,
        LABEL_INTER_VOLLEY_TICKS_REQUIRED = 1,
        LABEL_RELOAD_TICKS_REQUIRED = 2
    };
    static inline const std::map<int, std::tuple<int, int, int> > emitterVolleyRepeatData =
    {
        {EMITTER_PRESET_PC_MAIN,                   { 1,   0,   6} }, // i.e. "one volley with zero ticks between each volley. Six ticks to reload after firing all volleys"
        {EMITTER_PRESET_PC_FORWARD_SLASH,          { 1,   0,  40} },
        {EMITTER_PRESET_PC_SIDE_SLASH,             { 1,   0,  40} },

        {EMITTER_PRESET_PC_SPREAD_CANNON,          { 1,   0,   6} },
        {EMITTER_PRESET_PC_HYPER_CANNON,           { 1,   0,   3} },
        {EMITTER_PRESET_PC_UPGRADED_FORWARD_SLASH, { 1,   0,  40} },
        {EMITTER_PRESET_PC_UPGRADED_SIDE_SLASH,    { 1,   0,  40} },

        {EMITTER_PRESET_DORU_MAIN,                 { 1,   0,  12} },

        {EMITTER_PRESET_RAY_MAIN,                  { 3,  15, 120} }, // One volley with zero ticks between each volley. 60 ticks to reload after firing all volleys.
        {EMITTER_PRESET_OCELLUS_MAIN,              { 1,   0,  60} },
        {EMITTER_PRESET_ANGELFISH_MAIN,            { 3,  15, 120} }, // Three volleys with six ticks between each volley. 180 ticks to reload after firing all volleys.
        {EMITTER_PRESET_ANTLION_MAIN,              { 3,  15, 120} },

        {EMITTER_PRESET_DISCUS_MAIN,               { 1,   0, 300} },
        {EMITTER_PRESET_CONSTANT_SELFDESTRUCT,     { 1,   0, 999} },
        {EMITTER_PRESET_CROSS_MAIN,                {10,  30,  30} },
        {EMITTER_PRESET_MISSILE_SELFDESTRUCT,      { 1,   0, 999} },

        {EMITTER_PRESET_PARTISAN_SUPPRESSION,      { 6,  15, 300} },
        {EMITTER_PRESET_PARTISAN_PERSISTENT,       { 3,  30, 300} },
        {EMITTER_PRESET_SUNFISH_MAIN,              { 4,  15, 120} },
        {EMITTER_PRESET_SPIRIT_MAIN,               { 1,   0, 999} },
        {EMITTER_PRESET_AEGIS_SUPPRESSION,         {15,  30, 180} },
        {EMITTER_PRESET_AEGIS_LASER,               { 8,   5, 220} }

    };

    static inline const std::map<int, std::pair<bool, int> > emitterTelegraph =
    {
        // Initial isActive, colour
        {EMITTER_PRESET_PC_MAIN,                   { false,  TELEGRAPH_COLOUR_BLACK} }, // Though PC ship produces no telegraphs
        {EMITTER_PRESET_PC_FORWARD_SLASH,          { false,  TELEGRAPH_COLOUR_BLACK} },
        {EMITTER_PRESET_PC_SIDE_SLASH,             { false,  TELEGRAPH_COLOUR_BLACK} },

        {EMITTER_PRESET_PC_SPREAD_CANNON,          { false,  TELEGRAPH_COLOUR_BLACK} },
        {EMITTER_PRESET_PC_HYPER_CANNON,           { false,  TELEGRAPH_COLOUR_BLACK} },
        {EMITTER_PRESET_PC_UPGRADED_FORWARD_SLASH, { false,  TELEGRAPH_COLOUR_BLACK} },
        {EMITTER_PRESET_PC_UPGRADED_SIDE_SLASH,    { false,  TELEGRAPH_COLOUR_BLACK} },

        {EMITTER_PRESET_DORU_MAIN,                 { false,  TELEGRAPH_COLOUR_BLACK} },

        {EMITTER_PRESET_RAY_MAIN,                  { true,   TELEGRAPH_COLOUR_BLUE } },
        {EMITTER_PRESET_OCELLUS_MAIN,              { true,   TELEGRAPH_COLOUR_BLACK} },
        {EMITTER_PRESET_ANGELFISH_MAIN,            { true,   TELEGRAPH_COLOUR_BLUE } },
        {EMITTER_PRESET_ANTLION_MAIN,              { true,   TELEGRAPH_COLOUR_BLACK} },

        {EMITTER_PRESET_DISCUS_MAIN,               { true,   TELEGRAPH_COLOUR_BLUE } },
        {EMITTER_PRESET_CONSTANT_SELFDESTRUCT,     { false,  TELEGRAPH_COLOUR_BLUE } },
        {EMITTER_PRESET_CROSS_MAIN,                { true,   TELEGRAPH_COLOUR_BLUE } },
        {EMITTER_PRESET_MISSILE_SELFDESTRUCT,      { false,  TELEGRAPH_COLOUR_BLUE } },

        {EMITTER_PRESET_PARTISAN_SUPPRESSION,      { true,   TELEGRAPH_COLOUR_BLUE } },
        {EMITTER_PRESET_PARTISAN_PERSISTENT,       { true,   TELEGRAPH_COLOUR_BLACK} },
        {EMITTER_PRESET_SUNFISH_MAIN,              { true,   TELEGRAPH_COLOUR_BLUE } },
        {EMITTER_PRESET_SPIRIT_MAIN,               { true,   TELEGRAPH_COLOUR_BLUE } },
        {EMITTER_PRESET_AEGIS_SUPPRESSION,         { true,   TELEGRAPH_COLOUR_BLUE } },
        {EMITTER_PRESET_AEGIS_LASER,               { true,   TELEGRAPH_COLOUR_BLACK} },
    };


};
