#ifndef EMITTER_H_INCLUDED
#define EMITTER_H_INCLUDED

#include "emitterindex.h"

#include "audio.h"

#include "bullet.h"

#include "timer.h"

#include <iostream>

// Analogous to a stencil/template for firing arcs and rings of bullets on repeat.
class Emitter : public Actor
{
    bool isOnline{};
    bool isNPCEmitter{};

    bool hasTrackedTarget{};
    Actor* trackedTarget{};

    bool willLockTrackedPosition{};
    bool hasTrackedPosition{};
    float trackedXPosition{};
    float trackedYPosition{};
    bool isTrackedPositionLocked{}; // The first Fire() will set the tracked position for all following Fire() until reload.


    int emitterPreset{};
    int bulletPreset{};

    bool isSpawnFiringDelay {};
    int spawnFiringDelay {};
    const int DEFAULT_SPAWN_FIRING_DELAY = Timer::LPS * 1.2;

    unsigned volleySize{}; // Number of bullets to fire. Bullets will be evenly spaced.
    float volleyArcWidth{};  //In radians. A full 2*PI rads will fire a circular ring of bullets.
    float volleyAngle{}; // In radians. The midpoint of the arc, i.e. what direction the emitter is aiming

    bool isReloading {};
    int currentVolley {}, numVolleys{};
    int interVolleyTicks{}, interVolleyTicksRequired{};
    int reloadTicks{}, reloadTicksRequired{};

    bool isTelegraphActive {};
    bool isTelegraphVisible {};
    int telegraphColour {};
    float telegraphScaling {}; // Note that that 1.0 is added to this number in logic.
    float telegraphScalingFactor {}; // Coefficient in the form of "telegraphScaling = 1.0 + spawnFiringDelay*telegraphScalingFactor;" Probably something like 0.32.
    float telegraphRotationOffset {};
    static const int TELEGRAPH_TICKS_MAX = Timer::LPS*0.5;

public:
    Emitter();
    Emitter(int emitter_preset);
    ~Emitter();

    void Initialize(int emitter_preset);

    void Logic();
    void Fire();

    void DrawTelegraph(float ship_move_angle);

    bool GetIsOnline() const { return isOnline; }
    void SetIsOnline(bool is_online){isOnline = is_online;}

    void SetIsNPCEmitter(bool is_npc){isNPCEmitter = is_npc;}

    Actor* GetTrackedTarget(){return trackedTarget;}
    void SetTrackedTarget(Actor* target)
    {
        trackedTarget = target;

        if(trackedTarget == nullptr)
            hasTrackedTarget = false;
        else
            hasTrackedTarget = true;
    }

    bool GetHasTrackedPosition() const { return hasTrackedPosition;}
    void SetHasTrackedPosition(bool b) {hasTrackedPosition = b;}

    float GetTrackedXPosition() const { return trackedXPosition; }
    void SetTrackedXPosition(float x){trackedXPosition = x;}
    float GetTrackedYPosition() const { return trackedYPosition; }
    void SetTrackedYPosition(float y){trackedYPosition = y;}
    void SetTrackedXYPosition(float x, float y){SetTrackedXPosition(x); SetTrackedYPosition(y);}

    void SetIsSpawnFiringDelay(bool is_delayed){spawnFiringDelay = is_delayed;}

    void SetVolleyAngle(float x){volleyAngle = x;}
};

#endif // EMITTER_H_INCLUDED
