#ifndef BULLETINDEX_H_INCLUDED
#define BULLETINDEX_H_INCLUDED

#include "tile.h"

#include "timer.h"

#include <map>

struct BulletIndex
{
    static const size_t NUM_FRAMES = 3;

    enum enumBulletPresets
    {
        BULLET_PRESET_PC_ARROW,
        BULLET_PRESET_PC_FORWARD_SLASH,
        BULLET_PRESET_PC_SIDE_SLASH,

        BULLET_PRESET_PC_LARGE_STAR_DARK,

        BULLET_PRESET_RAY_ARROW,
        BULLET_PRESET_OCELLUS_SPHERE,
        BULLET_PRESET_ANGELFISH_PELLET,
        BULLET_PRESET_ANTLION_LARGE_STAR,

        BULLET_PRESET_DISCUS_PELLET,
        BULLET_PRESET_CONSTANT_SPHERE,
        BULLET_PRESET_CROSS_ARROW,
        BULLET_PRESET_MISSILE_PELLET,

        BULLET_PRESET_PARTISAN_ARROW,
        BULLET_PRESET_PARTISAN_ARROW_DARK,
        BULLET_PRESET_SUNFISH_PELLET,
        BULLET_PRESET_SPIRIT_SPHERE,
        BULLET_PRESET_AEGIS_PELLET,
        BULLET_PRESET_AEGIS_LARGE_STAR_DARK,
    };

    enum enumBulletSprites
    {
        SHAPE_SPHERE = 0,
        SHAPE_PELLET = 1,
        SHAPE_ARROW = 2,
        SHAPE_LARGE_STAR = 3,

        SHAPE_SPHERE_DARK = 4,
        SHAPE_PELLET_DARK = 5,
        SHAPE_ARROW_DARK = 6,
        SHAPE_LARGE_STAR_DARK = 7,

        SHAPE_FORWARD_SLASH = 8,
        SHAPE_SIDE_SLASH = 9
    };
    static const int SHAPE_MAIN_MARKER_BEGIN = SHAPE_SPHERE;
    static const int SHAPE_MAIN_MARKER_END = SHAPE_LARGE_STAR;
    static const int NUM_MAIN_SHAPES = 4;
    static const int SHAPE_DARK_MARKER_BEGIN = SHAPE_SPHERE_DARK;
    static const int SHAPE_DARK_MARKER_END = SHAPE_LARGE_STAR_DARK;
    static const int NUM_DARK_SHAPES = 4;
    static const int SHAPE_SLASH_MARKER_BEGIN = SHAPE_FORWARD_SLASH;
    static const int SHAPE_SLASH_MARKER_END = SHAPE_SIDE_SLASH;
    static const int NUM_SLASH_SHAPES = SHAPE_SLASH_MARKER_END - SHAPE_SLASH_MARKER_BEGIN + 1;
    static const int NUM_ALL_SHAPES = NUM_MAIN_SHAPES + NUM_DARK_SHAPES + NUM_SLASH_SHAPES;

    static inline const std::map<int, int>bulletSprite
    {
        {BULLET_PRESET_PC_ARROW,                        SHAPE_ARROW},
        {BULLET_PRESET_PC_FORWARD_SLASH,        SHAPE_FORWARD_SLASH},
        {BULLET_PRESET_PC_SIDE_SLASH,              SHAPE_SIDE_SLASH},

        {BULLET_PRESET_PC_LARGE_STAR_DARK,    SHAPE_LARGE_STAR_DARK},

        {BULLET_PRESET_RAY_ARROW,                       SHAPE_ARROW},
        {BULLET_PRESET_OCELLUS_SPHERE,            SHAPE_SPHERE_DARK},
        {BULLET_PRESET_ANGELFISH_PELLET,               SHAPE_PELLET},
        {BULLET_PRESET_ANTLION_LARGE_STAR,    SHAPE_LARGE_STAR_DARK},

        {BULLET_PRESET_DISCUS_PELLET,                  SHAPE_PELLET},
        {BULLET_PRESET_CONSTANT_SPHERE,                SHAPE_SPHERE},
        {BULLET_PRESET_CROSS_ARROW,                     SHAPE_ARROW},
        {BULLET_PRESET_MISSILE_PELLET,                 SHAPE_PELLET},

        {BULLET_PRESET_PARTISAN_ARROW,                  SHAPE_ARROW},
        {BULLET_PRESET_PARTISAN_ARROW_DARK,        SHAPE_ARROW_DARK},
        {BULLET_PRESET_SUNFISH_PELLET,                 SHAPE_PELLET},
        {BULLET_PRESET_SPIRIT_SPHERE,                  SHAPE_SPHERE},
        {BULLET_PRESET_AEGIS_PELLET,                   SHAPE_PELLET},
        {BULLET_PRESET_AEGIS_LARGE_STAR_DARK, SHAPE_LARGE_STAR_DARK}
    };

    static inline const std::map<int, std::pair<float,float>>bulletSpriteDimensions
    {
        {SHAPE_SPHERE,           {1*Tile::WIDTH, 1*Tile::HEIGHT}},
        {SHAPE_PELLET,           {1*Tile::WIDTH, 1*Tile::HEIGHT}},
        {SHAPE_ARROW,            {1*Tile::WIDTH, 1*Tile::HEIGHT}},
        {SHAPE_LARGE_STAR,       {1*Tile::WIDTH, 1*Tile::HEIGHT}},
        {SHAPE_SPHERE_DARK,      {1*Tile::WIDTH, 1*Tile::HEIGHT}},
        {SHAPE_PELLET_DARK,      {1*Tile::WIDTH, 1*Tile::HEIGHT}},
        {SHAPE_ARROW_DARK,       {1*Tile::WIDTH, 1*Tile::HEIGHT}},
        {SHAPE_LARGE_STAR_DARK,  {1*Tile::WIDTH, 1*Tile::HEIGHT}},

        {SHAPE_FORWARD_SLASH,    {2*Tile::WIDTH, 3*Tile::HEIGHT}},
        {SHAPE_SIDE_SLASH,       {2*Tile::WIDTH, 3*Tile::HEIGHT}},
    };

    static inline const std::map<int, std::pair<float,float>>bulletHitboxXYOffset
    {
        {SHAPE_SPHERE,           { -40,  -40}},
        {SHAPE_PELLET,           { -24,  -24}},
        {SHAPE_ARROW,            { -16,  -16}},
        {SHAPE_LARGE_STAR,       { -32,  -32}},
        {SHAPE_SPHERE_DARK,      { -40,  -40}},
        {SHAPE_PELLET_DARK,      { -24,  -24}},
        {SHAPE_ARROW_DARK,       { -16,  -16}},
        {SHAPE_LARGE_STAR_DARK,  { -32,  -32}},

        {SHAPE_FORWARD_SLASH,    { -88, -128}},
        {SHAPE_SIDE_SLASH,       {-138,  -64}}
    };

    static inline const std::map<int, std::pair<float,float>>bulletHitboxDimensions
    {
        {SHAPE_SPHERE,           { 80, 80}},
        {SHAPE_PELLET,           { 48, 48}},
        {SHAPE_ARROW,            { 32, 32}},
        {SHAPE_LARGE_STAR,       { 64, 64}},
        {SHAPE_SPHERE_DARK,      { 80, 80}},
        {SHAPE_PELLET_DARK,      { 48, 48}},
        {SHAPE_ARROW_DARK,       { 32, 32}},
        {SHAPE_LARGE_STAR_DARK,  { 64, 64}},

        {SHAPE_FORWARD_SLASH,    {176,256}},
        {SHAPE_SIDE_SLASH,       {264,120}}
    };

    static constexpr float NPC_BULLET_BASE_MOVESPEED = 4.0;
    static constexpr float PC_BULLET_BASE_MOVESPEED = 32.0;
    static inline const std::map<int, float>bulletMovespeed
    {
        {BULLET_PRESET_PC_ARROW,              PC_BULLET_BASE_MOVESPEED},
        {BULLET_PRESET_PC_FORWARD_SLASH,      PC_BULLET_BASE_MOVESPEED},
        {BULLET_PRESET_PC_SIDE_SLASH,         PC_BULLET_BASE_MOVESPEED},

        {BULLET_PRESET_PC_LARGE_STAR_DARK,    PC_BULLET_BASE_MOVESPEED*1.5},

        {BULLET_PRESET_RAY_ARROW,             NPC_BULLET_BASE_MOVESPEED},
        {BULLET_PRESET_OCELLUS_SPHERE,        NPC_BULLET_BASE_MOVESPEED},
        {BULLET_PRESET_ANGELFISH_PELLET,      NPC_BULLET_BASE_MOVESPEED},
        {BULLET_PRESET_ANTLION_LARGE_STAR,    NPC_BULLET_BASE_MOVESPEED},

        {BULLET_PRESET_DISCUS_PELLET,         NPC_BULLET_BASE_MOVESPEED},
        {BULLET_PRESET_CONSTANT_SPHERE,       NPC_BULLET_BASE_MOVESPEED*2},
        {BULLET_PRESET_CROSS_ARROW,           NPC_BULLET_BASE_MOVESPEED},
        {BULLET_PRESET_MISSILE_PELLET,        NPC_BULLET_BASE_MOVESPEED*3},

        {BULLET_PRESET_PARTISAN_ARROW,        NPC_BULLET_BASE_MOVESPEED},
        {BULLET_PRESET_PARTISAN_ARROW_DARK,   NPC_BULLET_BASE_MOVESPEED},
        {BULLET_PRESET_SUNFISH_PELLET,        NPC_BULLET_BASE_MOVESPEED},
        {BULLET_PRESET_SPIRIT_SPHERE,         NPC_BULLET_BASE_MOVESPEED*2},
        {BULLET_PRESET_AEGIS_PELLET,          NPC_BULLET_BASE_MOVESPEED*0.5},
        {BULLET_PRESET_AEGIS_LARGE_STAR_DARK, NPC_BULLET_BASE_MOVESPEED*2},
    };

    static const int BULLET_BASE_DAMAGE = 1;
    static inline const std::map<int, int> bulletDamage
    {
        {BULLET_PRESET_PC_ARROW,                               4},
        {BULLET_PRESET_PC_FORWARD_SLASH,                      10},
        {BULLET_PRESET_PC_SIDE_SLASH,                         10},

        {BULLET_PRESET_PC_LARGE_STAR_DARK,                     5},

        {BULLET_PRESET_RAY_ARROW,             BULLET_BASE_DAMAGE},
        {BULLET_PRESET_OCELLUS_SPHERE,        BULLET_BASE_DAMAGE},
        {BULLET_PRESET_ANGELFISH_PELLET,      BULLET_BASE_DAMAGE},
        {BULLET_PRESET_ANTLION_LARGE_STAR,    BULLET_BASE_DAMAGE},
        {BULLET_PRESET_DISCUS_PELLET,         BULLET_BASE_DAMAGE},
        {BULLET_PRESET_CROSS_ARROW,           BULLET_BASE_DAMAGE},
        {BULLET_PRESET_CONSTANT_SPHERE,       BULLET_BASE_DAMAGE},
        {BULLET_PRESET_MISSILE_PELLET,        BULLET_BASE_DAMAGE},
        {BULLET_PRESET_PARTISAN_ARROW,        BULLET_BASE_DAMAGE},
        {BULLET_PRESET_PARTISAN_ARROW_DARK,   BULLET_BASE_DAMAGE},
        {BULLET_PRESET_SUNFISH_PELLET,        BULLET_BASE_DAMAGE},
        {BULLET_PRESET_SPIRIT_SPHERE,         BULLET_BASE_DAMAGE},
        {BULLET_PRESET_AEGIS_PELLET,          BULLET_BASE_DAMAGE},
        {BULLET_PRESET_AEGIS_LARGE_STAR_DARK, BULLET_BASE_DAMAGE},
    };

    static const int BULLET_BASE_LIFESPAN = 5*Timer::LPS;
    static inline const std::map<int, int> bulletLifespan
    {
        {BULLET_PRESET_PC_ARROW,              BULLET_BASE_LIFESPAN},
        {BULLET_PRESET_PC_FORWARD_SLASH,           0.33*Timer::LPS},
        {BULLET_PRESET_PC_SIDE_SLASH,              0.33*Timer::LPS},

        {BULLET_PRESET_PC_LARGE_STAR_DARK,    BULLET_BASE_LIFESPAN},

        {BULLET_PRESET_RAY_ARROW,             BULLET_BASE_LIFESPAN},
        {BULLET_PRESET_OCELLUS_SPHERE,        BULLET_BASE_LIFESPAN},
        {BULLET_PRESET_ANGELFISH_PELLET,      BULLET_BASE_LIFESPAN},
        {BULLET_PRESET_ANTLION_LARGE_STAR,    BULLET_BASE_LIFESPAN},

        {BULLET_PRESET_DISCUS_PELLET,         BULLET_BASE_LIFESPAN},
        {BULLET_PRESET_CONSTANT_SPHERE,       BULLET_BASE_LIFESPAN},
        {BULLET_PRESET_CROSS_ARROW,           BULLET_BASE_LIFESPAN},
        {BULLET_PRESET_MISSILE_PELLET,        BULLET_BASE_LIFESPAN},

        {BULLET_PRESET_PARTISAN_ARROW,        BULLET_BASE_LIFESPAN},
        {BULLET_PRESET_PARTISAN_ARROW_DARK,   BULLET_BASE_LIFESPAN},
        {BULLET_PRESET_SUNFISH_PELLET,        BULLET_BASE_LIFESPAN},
        {BULLET_PRESET_SPIRIT_SPHERE,         BULLET_BASE_LIFESPAN},
        {BULLET_PRESET_AEGIS_PELLET,          BULLET_BASE_LIFESPAN},
        {BULLET_PRESET_AEGIS_LARGE_STAR_DARK, BULLET_BASE_LIFESPAN},
    };

    static inline const std::map<int, bool> bulletIsPersistent
    {
        {BULLET_PRESET_PC_ARROW,             false},
        {BULLET_PRESET_PC_FORWARD_SLASH,      true},
        {BULLET_PRESET_PC_SIDE_SLASH,         true},

        {BULLET_PRESET_PC_LARGE_STAR_DARK,    true},

        {BULLET_PRESET_RAY_ARROW,            false},
        {BULLET_PRESET_OCELLUS_SPHERE,        true},
        {BULLET_PRESET_ANGELFISH_PELLET,     false},
        {BULLET_PRESET_ANTLION_LARGE_STAR,    true},

        {BULLET_PRESET_DISCUS_PELLET,        false},
        {BULLET_PRESET_CONSTANT_SPHERE,      false},
        {BULLET_PRESET_CROSS_ARROW,          false},
        {BULLET_PRESET_MISSILE_PELLET,       true},

        {BULLET_PRESET_PARTISAN_ARROW,       false},
        {BULLET_PRESET_PARTISAN_ARROW_DARK,   true},
        {BULLET_PRESET_SUNFISH_PELLET,       false},
        {BULLET_PRESET_SPIRIT_SPHERE,        false},
        {BULLET_PRESET_AEGIS_PELLET,         false},
        {BULLET_PRESET_AEGIS_LARGE_STAR_DARK, true}
    };

};

#endif // BULLETINDEX_H_INCLUDED
