#ifndef BULLET_H_INCLUDED
#define BULLET_H_INCLUDED

#include "particle.h"
#include "bulletindex.h"

#include "shader.h"

#include "hax.h"

class Bullet : public Particle
{
    bool isNPCBullet{};
    int damage{};

    bool isPersistent{}; // Persistent bullets do not disappear after hitting a target.
                         // The same target cannot be hit by the same persistent bullet twice.
                         // Persistent bullets erase non-persistent hostile bullets on contact.


public:
    static std::vector<Bullet*>bullets;

    Bullet();
    ~Bullet();

    void Logic();

    void Drawing();

    void Initialize(int preset, float angle);
    void EmitHitSparks(int particle_form, int num_hit_sparks);

    bool GetIsNPCBullet() const { return isNPCBullet; }
    void SetIsNPCBullet(bool is_npc_bullet){isNPCBullet = is_npc_bullet;}

    int GetDamage() const { return damage; }
    void SetDamage(int dmg){damage = dmg;}

    bool GetIsPersistent() const {return isPersistent;}
    void SetIsPersistent(bool is_persistent){ isPersistent = is_persistent;}
};

#endif // BULLET_H_INCLUDED
