#ifndef AUDIO_H_INCLUDED
#define AUDIO_H_INCLUDED

#include <allegro5/allegro_audio.h>
#include <allegro5/allegro_acodec.h>

#include <vector>

struct Audio
{
    static ALLEGRO_SAMPLE_INSTANCE*activeBgmInstance;
    static std::vector<ALLEGRO_SAMPLE_INSTANCE*>activeSfxInstances;

    static ALLEGRO_SAMPLE*titleBgm;
    static ALLEGRO_SAMPLE*s1s2Bgm;
    static ALLEGRO_SAMPLE*s3Bgm;

    static ALLEGRO_SAMPLE*uiSelect0;

    static ALLEGRO_SAMPLE*fireTransient0;
    static ALLEGRO_SAMPLE*firePersistent0;

    static ALLEGRO_SAMPLE*pcHit0;

    static const int NUM_EXPLOSIONS = 6;
    static ALLEGRO_SAMPLE*explosion[NUM_EXPLOSIONS];

    static ALLEGRO_SAMPLE*multiplierAdvance0;
    static ALLEGRO_SAMPLE*warning0;
    static ALLEGRO_SAMPLE*edgeAlert0;
    static ALLEGRO_SAMPLE*pickup0;

    static ALLEGRO_SAMPLE*boost0;


    //static ALLEGRO_SAMPLE*sfxTestTone;

    static ALLEGRO_SAMPLE*genericLaserShootWav;

    static float bgmGain;
    static float sfxGain;

    static void Initialize();
    static void Uninitialize();

    static void LoadResources();
    static void UnloadResources();

    static void SetBgmGain(float gain);
    static void SetSfxGain(float gain);

    static void AddSfx(ALLEGRO_SAMPLE* whichSfx);
    static void SetActiveBgm(ALLEGRO_SAMPLE* whichBgm, unsigned int position_secs);

    static void OverworldParallelAudioUpdate();
    static void OverworldBeginParallelBackgroundAudio();
    static void OverworldEndParallelBackgroundAudio();
    static void OverworldSwapParallelBackgroundAudioToPlace();
    static void OverworldSwapParallelBackgroundAudioToField();

    static void Logic();
};

#endif // AUDIO_H_INCLUDED
