#ifndef ARENA_H_INCLUDED
#define ARENA_H_INCLUDED

#include "display.h"

struct Arena
{
    static constexpr float X_POSITION = 0;
    static constexpr float Y_POSITION = 0;

    static constexpr float WIDTH = Display::WIDTH;
    static constexpr float HEIGHT = Display::HEIGHT;

    static constexpr float LEFT_WALL = X_POSITION;
    static constexpr float RIGHT_WALL = WIDTH;
    static constexpr float TOP_WALL = Y_POSITION;
    static constexpr float BOTTOM_WALL = HEIGHT;

    static constexpr float TOP_WALL_MID = WIDTH/2;
    static constexpr float BOTTOM_WALL_MID = WIDTH/2;
    static constexpr float LEFT_WALL_MID = HEIGHT/2;
    static constexpr float RIGHT_WALL_MID = HEIGHT/2;

    static bool pursuitModeActive;
    static constexpr float PURSUIT_MODE_AFTERIMAGE_Y_BOOST = 16.0;

    static void Initialize()
    {
        pursuitModeActive = false;
    }

    static void Uninitialize()
    {

    }
};

#endif // ARENA_H_INCLUDED
