#pragma once

#include <allegro5/allegro_primitives.h>

#include "tile.h"
#include "timer.h"

#include "arena.h"

class Actor
{
    bool isActive{};
    bool isAlive{};
    bool isInBounds{};
    bool isVisible{};
    bool isCollidable{};
    bool wasMoved{};

    float xPosition{}, yPosition{};
    float previousXPosition{}, previousYPosition{};
    float interpolatedXPosition{}, interpolatedYPosition{};

    float moveSpeed{};
    float moveAngle{};

    float spriteWidth{}, spriteHeight{};
    float spriteRotation{};
    float previousSpriteRotation{};
    float interpolatedSpriteRotation{};

    float hitboxXOffset{}, hitboxYOffset{};
    float hitboxWidth{}, hitboxHeight{};

    int spawnOutOfBoundsCheckDelay;
    static const int DEFAULT_SPAWN_OUT_OF_BOUNDS_CHECK_DELAY = Timer::LPS * 2.0;

    int currentFrame{}, numFrames{};
    int currentFrameDelay{}, maxFrameDelay{};
    static const int DEFAULT_MAX_FRAME_DELAY = Timer::LPS*0.1;


public:
    Actor();
    ~Actor();

// Comment out to disable
///#define DEBUG_PRIMITIVES
    void DebugDrawPosition()
    {
#ifdef DEBUG_PRIMITIVES
        al_draw_circle(GetXPosition(),GetYPosition(),4,al_map_rgb(255,0,255), 2);
#endif
    }
    void DebugDrawHitbox()
    {
#ifdef DEBUG_PRIMITIVES
        al_draw_circle(GetXPosition() + GetHitboxXOffset(), GetYPosition() + GetHitboxYOffset(), 4, al_map_rgb(255, 0, 0), 2);
        al_draw_rectangle(GetXPosition()+GetHitboxXOffset(),
                          GetYPosition()+GetHitboxYOffset(),
                          GetXPosition()+GetHitboxXOffset() + GetHitboxWidth(),
                          GetYPosition()+GetHitboxYOffset() + GetHitboxHeight(),
                          al_map_rgb(255,0,0), 2);
#endif
    }

    void Initialize();

    void Logic();

    void UpdateInterpolation();

    bool GetIsActive() const { return isActive; }
    void SetIsActive(bool active){isActive = active;}

    bool GetIsAlive() const { return isAlive; }
    void SetIsAlive(bool alive){isAlive = alive;}

    bool GetIsInBounds() const { return isInBounds; }
    void SetIsInBounds(bool inBounds){ isInBounds = inBounds;}

    //bool GetIsVisible() const { return isVisible; }
    //void SetIsVisible(bool visible){isVisible = visible;}

    //bool GetIsCollidable() const { return isCollidable; }
    //void SetIsCollidable(bool collidable){isCollidable = collidable;}

    //bool GetWasMoved() const { return wasMoved;}
    //void SetWasMoved(bool was_moved){wasMoved = was_moved;}

    float GetXPosition() const { return xPosition; }
    void SetXPosition(float x){xPosition = x;}
    float GetYPosition() const { return yPosition; }
    void SetYPosition(float y){yPosition = y;}
    void SetXYPosition(float x, float y){ SetXPosition(x); SetYPosition(y); }
    float GetPreviousXPosition() const { return previousXPosition; }
    void SetPreviousXPosition(float x){previousXPosition = x;}
    float GetPreviousYPosition() const { return previousYPosition; }
    void SetPreviousYPosition(float y){previousYPosition = y;}
    void SetPreviousXYPosition(float x, float y){ SetPreviousXPosition(x); SetPreviousYPosition(y); }
    float GetInterpolatedXPosition() const { return interpolatedXPosition; }
    void SetInterpolatedXPosition(float x){interpolatedXPosition = x;}
    float GetInterpolatedYPosition() const { return interpolatedYPosition; }
    void SetInterpolatedYPosition(float y){interpolatedYPosition = y;}
    void SetInterpolatedXYPosition(float x, float y){ SetInterpolatedXPosition(x); SetInterpolatedYPosition(y); }
    void SetAllXPositions(float x){ SetXPosition(x); SetPreviousXPosition(x); SetInterpolatedXPosition(x);}
    void SetAllYPositions(float y){ SetYPosition(y); SetPreviousYPosition(y); SetInterpolatedYPosition(y);}
    void SetAllXYPositions(float x, float y){ SetXYPosition(x, y); SetPreviousXYPosition(x, y); SetInterpolatedXYPosition(x, y); }


    float GetMoveSpeed() const { return moveSpeed; }
    void SetMoveSpeed(float speed){moveSpeed = speed;}

    float GetMoveAngle() const { return moveAngle; }
    void SetMoveAngle(float a){moveAngle = a;}

    float GetSpriteWidth() const { return spriteWidth; }
    void SetSpriteWidth(float w){spriteWidth = w;}
    float GetSpriteHeight() const { return spriteHeight; }
    void SetSpriteHeight(float h){spriteHeight = h;}
    void SetSpriteDimensions(float w, float h){SetSpriteWidth(w); SetSpriteHeight(h);}

    float GetSpriteRotation() const { return spriteRotation; }
    void SetSpriteRotation(float angle){spriteRotation = angle;}
    float GetPreviousSpriteRotation() const {return previousSpriteRotation;}
    void SetPreviousSpriteRotation(float a){previousSpriteRotation = a;}
    float GetInterpolatedSpriteRotation() const {return interpolatedSpriteRotation;}
    void SetInterpolatedSpriteRotation(float a){interpolatedSpriteRotation = a;}
    void SetAllSpriteRotations(float a){ SetSpriteRotation(a); SetPreviousSpriteRotation(a); SetInterpolatedSpriteRotation(a);}

    float GetHitboxXOffset() const { return hitboxXOffset; }
    void SetHitboxXOffset(float x){hitboxXOffset = x;}
    float GetHitboxYOffset() const { return hitboxYOffset; }
    void SetHitboxYOffset(float y){hitboxYOffset = y;}
    void SetHitboxXYOffset(float x, float y){SetHitboxXOffset(x); SetHitboxYOffset(y);}

    float GetHitboxWidth() const { return hitboxWidth; }
    void SetHitboxWidth(float w){hitboxWidth = w;}
    float GetHitboxHeight() const { return hitboxHeight; }
    void SetHitboxHeight(float h){hitboxHeight = h;}
    void SetHitboxDimensions(float w, float h){ SetHitboxWidth(w); SetHitboxHeight(h);}

    int GetCurrentFrame() const {return currentFrame;}
    void SetCurrentFrame(int current_frame){currentFrame = current_frame;}
    int GetNumFrames() const {return numFrames;}
    void SetNumFrames(int num_frames){numFrames = num_frames;}
    int GetCurrentFrameDelay() const {return currentFrameDelay;}
    void SetCurrentFrameDelay(int current_frame_delay){currentFrameDelay = current_frame_delay;}
    int GetMaxFrameDelay() const {return maxFrameDelay;}
    void SetMaxFrameDelay(int max_frame_delay){maxFrameDelay = max_frame_delay;}


};
