#ifndef TRAIN_H
#define TRAIN_H

#include <allegro5/allegro.h>
#include "GameTypes.h"
#include "Map.h"
#include "Track.h"
#include "Timer.h"
#include "Player.h"

// The maximum number of carriages in the train.
#define MAX_CARRIAGE_COUNT 5

// The train object made up of carriages that runs along the tracks.
typedef struct Train Train;

struct Train
{
    // The x positions that the carriages of the train currently occupy.
    u8 x[MAX_CARRIAGE_COUNT];

    // The y positions that the carriages of the train currently occupy.
    u8 y[MAX_CARRIAGE_COUNT];

    // The next x position that the train will travel to.
    u8 nextX;

    // The next y position that the train will travel to.
    u8 nextY;

    // The number of carriages currently on the screen.
    u8 carriageCount;

    // The direction that the train is travelling in.
    u8 direction;

    // Indicates whether the train should be redrawn on screen.
    u8 redraw;
};

// Global train object.
extern Train train;

// Initialises the train for a new start position and no carriages on the map.
void initTrain(u8 startX, u8 startY);

// Draw the train carriages on the map.
void drawTrain();

// Runs the train logic to update the position of the train on the map.
void logicTrain();

// Draws a carriage on screen at the specified position.
void drawCarriage(u8 x, u8 y);

// Indicates whether the next cell in the specified direction is a valid cell for the train.
u8 isNextCellValid(u8 nextCell, u8 direction);

// Determines the direction that the next cell is in.
u8 nextDirection(u8 nextCell, u8 direction);

// Indicates whether the specified cell coordinates currently contains a carriage.
u8 cellContainsCarriage(u8 x, u8 y);

#endif