#ifndef TIMER_H
#define TIMER_H

#include <allegro5/allegro.h>
#include "GameState.h"
#include "GameTypes.h"

// Initialises the ALLEGRO_TIMERs used in the game.
void initialiseAllAllegroTimers();

// Destroys all the ALLEGRO_TIMERs used in the game.
void destroyAllAllegroTimers();

// Indicates whether the train timer has elapsed which will cause the train to move.
u8 trainTimerElapsed();

// Starts the train timer used to slow down the train.
void startTrainTimer();

// Starts the level countdown which is the delay before the train starts.
void startCountDownTimer(u8 initialCountDown);

// The amount of time remaining before the train can start.
u8 countDownRemaining();

// Stops the level countdown timer.
void stopCountDownTimer();

// Indicates whether the count down has completed or not.
u8 countDownStopped();

#endif