#include "Timer.h"

// Train timer that determines how fast the train travels along the tracks.
ALLEGRO_TIMER* trainTimer_ = NULL;

// Timer used to count down for the train to start moving.
ALLEGRO_TIMER* countDownTimer_ = NULL;

// The value that the count down timer will count down from.
u8 initialCountDown_ = 15;

void initialiseAllAllegroTimers()
{
    trainTimer_ = al_create_timer(0.1);
    countDownTimer_ = al_create_timer(1);
}

void destroyAllAllegroTimers()
{
    al_destroy_timer(trainTimer_);
    al_destroy_timer(countDownTimer_);
}

u8 trainTimerElapsed()
{
    if (al_get_timer_count(trainTimer_) > trainSpeed)
    {
        // Stop the train timer and reset the time.
        al_stop_timer(trainTimer_);
        al_set_timer_count(trainTimer_, 0);

        return TRUE;
    }
    else
    {
        return FALSE;
    }
}

// Starts the train timer used to slow down the train.
void startTrainTimer()
{
    al_start_timer(trainTimer_);
}

void startCountDownTimer(u8 initialCountDown)
{
    initialCountDown_ = initialCountDown;
    al_start_timer(countDownTimer_);
}

u8 countDownRemaining()
{
    if (al_get_timer_started(countDownTimer_))
    {
        if (al_get_timer_count(countDownTimer_) > initialCountDown_)
        {
            return 0;
        }
        else
        {
            return initialCountDown_ - al_get_timer_count(countDownTimer_);
        }
    }
    else
    {
        // Timer stopped so return 0.
        return 0;
    }
}

void stopCountDownTimer()
{
    al_stop_timer(countDownTimer_);
}

u8 countDownStopped()
{
    return !al_get_timer_started(countDownTimer_);
}