#ifndef TEXT_H
#define TEXT_H

#include <allegro5/allegro.h>
#include <allegro5/allegro_font.h>
#include <stdio.h>
#include "GameTypes.h"

// The offset used for converting a number to ascii for drawing on screen.
#define ASCII_TO_NUMBER_OFFSET 48

// Draws a string at a specified position on screen using the game font.
void drawString(u16 x, u16 y, u8 scaleFactor, const u8* string, ALLEGRO_COLOR textColour);

// Initialise fonts used by Allegro.
void initFonts(const char* fontPath);

// Destroy fonts used by Allegro.
void destroyFonts();

// Draws the specified score at the specified position with appropriate zero padding using allegro.
void drawScoreAllegro(u16 score, u16 x, u16 y, u8 scaleFactor, ALLEGRO_COLOR textColour);

// Converts a 16 bit number to an equivalent string of characters for printing on screen.
void convertNumberToString(u16 input, u8* output);

#endif