#include "Text.h"

ALLEGRO_FONT* defaultFont_ = NULL;

void initFonts(const char* fontPath)
{
    defaultFont_ = al_load_font(fontPath, 14 * scaleFactor, 0);
}

void drawString(u16 x, u16 y, u8 scaleFactor, const u8* string, ALLEGRO_COLOR textColour)
{
    al_draw_text(defaultFont_, textColour, x * scaleFactor, y * scaleFactor, 0, string);
}

void destroyFonts()
{
    al_destroy_font(defaultFont_);
}

void drawScoreAllegro(u16 score, u16 x, u16 y, u8 scaleFactor, ALLEGRO_COLOR textColour)
{
    // Pad the score with 0s to make a consistent size on the display.
    static u8 scoreText[8];

    // sprintf_s is not available in VC6.
#if _MSC_VER > 1200
    sprintf_s(scoreText, 8, "%07d", score);
#else
    sprintf(scoreText, "%07d", score);
#endif
    drawString(x, y, scaleFactor, scoreText, textColour);
}

void convertNumberToString(u16 input, u8* output)
{
    // Need to add 48 to each number to actually display the correct number on screen.
    u8 nextDigit = FALSE;

    if (input >= 10000)
    {
        *output = (input / 10000) + ASCII_TO_NUMBER_OFFSET;
        ++output;
        input = (input % 10000);
        nextDigit = TRUE;
    }

    if (input >= 1000 || nextDigit)
    {
        *output = (input / 1000) + ASCII_TO_NUMBER_OFFSET;
        ++output;
        input = (input % 1000);
        nextDigit = TRUE;
    }

    if (input >= 100 || nextDigit)
    {
        *output = (input / 100) + ASCII_TO_NUMBER_OFFSET;
        ++output;
        input = (input % 100);
        nextDigit = TRUE;
    }

    if (input >= 10 || nextDigit)
    {
        *output = (input / 10) + ASCII_TO_NUMBER_OFFSET;
        ++output;
        input = (input % 10);
        nextDigit = TRUE;
    }

    if (input < 10 || nextDigit)
    {
        *output = input + ASCII_TO_NUMBER_OFFSET;
        ++output;
    }

    // Add the null terminator at the end.
    *output = '\0';
}