#ifndef SPRITESETS_H
#define SPRITESETS_H

#include <allegro5/allegro.h>
#include "sprites/TrackSprites.h"
#include "sprites/EnvironmentSprites.h"
#include "sprites/FeatureSprites.h"
#include "sprites/MiscSprites.h"
#include "sprites/TrainSprites.h"
#include "SpriteUtil.h"

// The number of track sprites in the track sprite set.
#define TRACK_SPRITE_COUNT 7

// The number of misc sprites in the misc sprite set.
#define MISC_SPRITE_COUNT 6

// The number of environment sprites in the environment sprite set.
#define ENVIRONMENT_SPRITE_COUNT 4

// The number of feature sprites in the feature sprite set.
#define FEATURE_SPRITE_COUNT 2

// The number of feature sprites in the train sprite set.
#define TRAIN_SPRITE_COUNT 5

// Array for accessing track sprites in CPC format.
extern const u8* const trackSprites[TRACK_SPRITE_COUNT];

// Array for accessing misc sprites in CPC format.
extern const u8* const miscSprites[MISC_SPRITE_COUNT];

// Array for accessing environment sprites in CPC format.
extern const u8* const environmentSprites[ENVIRONMENT_SPRITE_COUNT];

// Array for accessing feature sprites in CPC format.
extern const u8* const featureSprites[FEATURE_SPRITE_COUNT];

// Array for accessing train sprites in CPC format.
extern const u8* const trainSprites[TRAIN_SPRITE_COUNT];

// Array for accessing track sprites in Allegro.
extern ALLEGRO_BITMAP* allegroTrackSprites[TRACK_SPRITE_COUNT];

// Array for accessing misc sprites in Allegro.
extern ALLEGRO_BITMAP* allegroMiscSprites[TRACK_SPRITE_COUNT];

// Array for accessing environment sprites in Allegro.
extern ALLEGRO_BITMAP* allegroEnvironmentSprites[ENVIRONMENT_SPRITE_COUNT];

// Array for accessing feature sprites in Allegro.
extern ALLEGRO_BITMAP* allegroFeatureSprites[FEATURE_SPRITE_COUNT];

// Array for accessing train sprites in Allegro.
extern ALLEGRO_BITMAP* allegroTrainSprites[TRAIN_SPRITE_COUNT];

// Initialise the all the sprites into ALLEGRO_BITMAP objects.
void initAllAllegroSpriteSets(u8 transparencyType);

// Initialise the tile size sprites into ALLEGRO_BITMAP objects.
void initAllegroSpriteSet(ALLEGRO_BITMAP** allegroBitmaps, u8** sprites, u8 width, u8 height, u8 count, u8 transparencyType);

// Destroys all the ALLEGRO_BITMAP objects in the allegro sprites array.
void destroyAllAllegroSpriteSets();

// Destroys all the ALLEGRO_BITMAP in the specified array.
void destroyAllegroSpriteSet(ALLEGRO_BITMAP** sprites, u8 count);

#endif