#include "SpriteSets.h"

// Array for accessing track sprites in Allegro.
ALLEGRO_BITMAP* allegroTrackSprites[TRACK_SPRITE_COUNT];

// Array for accessing misc sprites in Allegro.
ALLEGRO_BITMAP* allegroMiscSprites[TRACK_SPRITE_COUNT];

// Array for accessing environment sprites in Allegro.
ALLEGRO_BITMAP* allegroEnvironmentSprites[ENVIRONMENT_SPRITE_COUNT];

// Array for accessing environment sprites in Allegro.
ALLEGRO_BITMAP* allegroFeatureSprites[FEATURE_SPRITE_COUNT];

// Array for accessing train sprites in Allegro.
ALLEGRO_BITMAP* allegroTrainSprites[TRAIN_SPRITE_COUNT];

const u8* const trackSprites[TRACK_SPRITE_COUNT] =
{
    G_track_vertical,
    G_track_horizontal,
    G_track_down_right,
    G_track_up_right,
    G_track_down_left,
    G_track_up_left,
    G_track_cross,
    // Turning these off to safe time figuring out valid next cell and next direction for them.
    //G_track_cross_down_right,
    //G_track_cross_up_right,
    //G_track_cross_down_left,
    //G_track_cross_up_left,
};

const u8* const miscSprites[MISC_SPRITE_COUNT] =
{
    G_cursor_white,
    G_cursor_black,
    G_cursor_red,
    G_cursor_yellow,
    G_cursor_blue,
    G_cursor_green,
};

const u8* const environmentSprites[ENVIRONMENT_SPRITE_COUNT] =
{
    G_environment_grass,
    G_environment_grass2,
    G_environment_land_plant4,
    G_environment_land_rock1,
};

const u8* const featureSprites[FEATURE_SPRITE_COUNT] =
{
    G_feature_start,
    G_feature_end,
};

const u8* const trainSprites[TRAIN_SPRITE_COUNT] =
{
    G_train_white,
    G_train_yellow,
    G_train_blue,
    G_train_green,
    G_train_red,
};

void initAllAllegroSpriteSets(u8 transparencyType)
{
    initAllegroSpriteSet(allegroTrackSprites, (u8**)trackSprites, TILE_WIDTH_BYTES, TILE_HEIGHT, TRACK_SPRITE_COUNT, transparencyType);
    initAllegroSpriteSet(allegroMiscSprites, (u8**)miscSprites, TILE_WIDTH_BYTES, TILE_HEIGHT, MISC_SPRITE_COUNT, 2);
    initAllegroSpriteSet(allegroEnvironmentSprites, (u8**)environmentSprites, TILE_WIDTH_BYTES, TILE_HEIGHT, ENVIRONMENT_SPRITE_COUNT, transparencyType);
    initAllegroSpriteSet(allegroFeatureSprites, (u8**)featureSprites, TILE_WIDTH_BYTES, TILE_HEIGHT, FEATURE_SPRITE_COUNT, transparencyType);
    initAllegroSpriteSet(allegroTrainSprites, (u8**)trainSprites, TILE_WIDTH_BYTES, TILE_HEIGHT, TRAIN_SPRITE_COUNT, transparencyType);
}

void initAllegroSpriteSet(ALLEGRO_BITMAP** allegroBitmaps, u8** sprites, u8 width, u8 height, u8 count, u8 transparencyType)
{
    u8 i = 0;

    // The palette defining the colours that will be used to draw the graphics in the game.
    const u8 gamePalette[16] = { 0xa, 0x13, 0xc, 0xb, 0x14, 0x0, 0x15, 0x17, 0x12, 0x16, 0x1e, 0x3, 0x7, 0xe, 0x1c, 0xd };

    for (i = 0; i < count; ++i)
    {
        allegroBitmaps[i] = constructBitmap(sprites[i], width * height, width, height, width * 2, gamePalette, transparencyType);
    }
}

void destroyAllAllegroSpriteSets()
{
    destroyAllegroSpriteSet(allegroTrackSprites, TRACK_SPRITE_COUNT);
    destroyAllegroSpriteSet(allegroMiscSprites, MISC_SPRITE_COUNT);
    destroyAllegroSpriteSet(allegroEnvironmentSprites, ENVIRONMENT_SPRITE_COUNT);
    destroyAllegroSpriteSet(allegroFeatureSprites, FEATURE_SPRITE_COUNT);
}

void destroyAllegroSpriteSet(ALLEGRO_BITMAP** sprites, u8 count)
{
    u8 i = 0;

    for (i = 0; i < count; ++i)
    {
        al_destroy_bitmap(sprites[i]);
    }
}