#ifndef PLAYER_H
#define PLAYER_H

#include <time.h>
#include "GameState.h"
#include "GameTypes.h"
#include "Hud.h"
#include "Keys.h"
#include "Map.h"
#include "SpriteSets.h"
#include "Track.h"
#include "Train.h"

typedef struct Player Player;

struct Player
{
    // X position of the player cursor.
    u8 x;

    // Y position of the player cursor.
    u8 y;

    // The previous X position of the player cursor.
    u8 previousX;

    // The previous Y position of the player cursor.
    u8 previousY;

    // The index of the player in the players array.
    u8 id;

    // The player's current score.
    u16 score;

    // The next pieces that the player can place in the grid.
    u8 nextPieces[NEXT_PIECE_COUNT];
};

// The players in the game.
extern Player players[MAX_PLAYER_COUNT];

// Initialises the player starting position and pieces.
void initPlayers(u8 playerCount);

// Initialises the next pieces with random values.
void initNextPieces(u8* nextPieces);

// Draws the player cursors on the screen.
void drawPlayers();

// Draws the cursor for the specified player on the screen.
void drawPlayer(Player* player);

// Updates the player cursor based on user input.
void movePlayer();

// Place the track at the player's current cursor position.
void placeTrack(Player* player);

#endif