#ifndef MENU_H
#define MENU_H

#include <allegro5/allegro.h>
#include <stdio.h>
#include "Game.h"
#include "GameTypes.h"
#include "Keys.h"
#include "Text.h"
#include "VersionNo.h"

// Sets up the main menu and runs the menu loop.
void runMenu(ALLEGRO_CONFIG* config, ALLEGRO_PATH* configPath);

// Draws the main menu on the screen.
void drawMenu();

// Sets up the event queue for allegro to start listening to events in the menu.
void setupMenuEventQueue(ALLEGRO_EVENT_QUEUE** eventQueue);

// Initialise the high score values.
void initHighScores();

// Displays the current high scores on the screen in a list.
void displayHighScores(ALLEGRO_EVENT_QUEUE** eventQueue);

// Get the user pressed key for rebind/redefine using Allegro.
u16 getKeyAllegro(ALLEGRO_EVENT_QUEUE** menuEventQueue);

// Reads the high scores from file.
void loadHighScores(const u8* filename);

// Displays the game options in a list where the player can update the options and save the to the game config file.
void displayOptions(ALLEGRO_EVENT_QUEUE** eventQueue, ALLEGRO_CONFIG* config, ALLEGRO_PATH* configPath);

// Runs the full game session and displays victory or defeat based on outcome.
void runFullGame(ALLEGRO_EVENT_QUEUE** eventQueue, ALLEGRO_CONFIG* config);

// Displays either victorious or game over depending on if the user completes the game or not.
void displayEndScreen(ALLEGRO_EVENT_QUEUE** eventQueue);

// Update the high scores if the player has a high score.
void updateHighScores(ALLEGRO_EVENT_QUEUE** eventQueue);

// Writes the high scores to a file.
void saveHighScores(const u8* filename);

// Allows the user to enter letters to form a word.
void enterWordAllegro(u8* word, u8 maxLength, u16 x, u16 y, ALLEGRO_EVENT_QUEUE** eventQueue);

#endif