#ifndef MAP_H
#define MAP_H

#include <allegro5/allegro5.h>
#include <string.h>
#include "GameTypes.h"
#include "MapManager.h"
#include "SpriteSets.h"

// The map grid.
extern u8 mapCells[MAP_CELL_COUNT];

// Determine when a map redraw should happen.
extern u8 mapRedraw;

// The map index of the current map in the maps array.
extern u8 currentMap;

// Initialises the map grid.
void initMap();

// Draws the contents of the map on screen.
void drawMap();

// Draws the content of a cell from the map on screen.
void drawCell(u8 x, u8 y, u8 cell);

// Retrieve the index in the mapCell array for the given position (x,y) and room (x,y).
u16 mapCellPosition(u8 x, u8 y, u8 roomX, u8 roomY);

// Retrieve the cell from the mapCell array for the given position (x,y) and room (x,y).
u8 mapCell(u8 x, u8 y, u8 roomX, u8 roomY);

// Retrieves a pointer to an ALLEGRO_BITMAP from a given cell value.
ALLEGRO_BITMAP* allegroBitmapFromCell(u8 cell);

// Draws the cell at the specified position in the map on screen.
void drawCellAtPosition(u8 x, u8 y);

// Updates the cell in the mapCell array at the given position (x,y) and room (x,y) and redraw the cell if it is in the current room.
void updateMapCellRedraw(u8 x, u8 y, u8 roomX, u8 roomY, u8 cell);

#endif