#ifndef KEYS_H
#define KEYS_H

#include <allegro5/allegro.h>
#include "GameTypes.h"
#include "Text.h"

// Control flag for left key detection.
#define CONTROL_LEFT_FLAG 1

// Control flag for right key detection.
#define CONTROL_RIGHT_FLAG 2

// Control flag for up key detection.
#define CONTROL_UP_FLAG 4

// Control flag for down key detection.
#define CONTROL_DOWN_FLAG 8

// Control flag for place track key detection.
#define CONTROL_TRACK_FLAG 16

// Control flag for exit key detection.
#define CONTROL_EXIT_FLAG 128

typedef struct Keys Keys;

// Defines the controls used in the game.
struct Keys
{
    // Key values for setting custom controls.
    u16 left;
    u16 right;
    u16 up;
    u16 down;
    u16 track;
    u16 exit;

    // Flags indicating what controls are down.
    u8 controlFlags;
};

// Player selected controls for movement and actions.
extern Keys gameControls;

// Sets the default player controls for the game (if the user does not customise the controls).
void setDefaultKeys(ALLEGRO_CONFIG* config);

// Update the controls flags based on the keys that are currently pressed down for Allegro.
void readGameControlsAllegro(ALLEGRO_EVENT* allegroEvent);

// Saves the user specified controls to the game configuration file.
void saveControls(ALLEGRO_CONFIG* config, ALLEGRO_PATH* configPath);

#endif