#include "Keys.h"

// Player selected controls for movement and actions.
Keys gameControls;

void setDefaultKeys(ALLEGRO_CONFIG* config)
{
    gameControls.left = ALLEGRO_KEY_LEFT;
    gameControls.right = ALLEGRO_KEY_RIGHT;
    gameControls.up = ALLEGRO_KEY_UP;
    gameControls.down = ALLEGRO_KEY_DOWN;
    gameControls.track = ALLEGRO_KEY_SPACE;
    gameControls.exit = ALLEGRO_KEY_ESCAPE;

    if (al_get_config_value(config, NULL, "controls_left") != NULL)
    {
        gameControls.left = atoi(al_get_config_value(config, NULL, "controls_left"));
    }

    if (al_get_config_value(config, NULL, "controls_right") != NULL)
    {
        gameControls.right = atoi(al_get_config_value(config, NULL, "controls_right"));
    }

    if (al_get_config_value(config, NULL, "controls_up") != NULL)
    {
        gameControls.up = atoi(al_get_config_value(config, NULL, "controls_up"));
    }

    if (al_get_config_value(config, NULL, "controls_down") != NULL)
    {
        gameControls.down = atoi(al_get_config_value(config, NULL, "controls_down"));
    }

    if (al_get_config_value(config, NULL, "controls_track") != NULL)
    {
        gameControls.track = atoi(al_get_config_value(config, NULL, "controls_track"));
    }

    if (al_get_config_value(config, NULL, "controls_exit") != NULL)
    {
        gameControls.exit = atoi(al_get_config_value(config, NULL, "controls_exit"));
    }
}

void readGameControlsAllegro(ALLEGRO_EVENT* allegroEvent)
{
    if (allegroEvent->type == ALLEGRO_EVENT_KEY_DOWN)
    {
        if (allegroEvent->keyboard.keycode == gameControls.left)
        {
            gameControls.controlFlags |= CONTROL_LEFT_FLAG;
        }

        if (allegroEvent->keyboard.keycode == gameControls.right)
        {
            gameControls.controlFlags |= CONTROL_RIGHT_FLAG;
        }

        if (allegroEvent->keyboard.keycode == gameControls.up)
        {
            gameControls.controlFlags |= CONTROL_UP_FLAG;
        }

        if (allegroEvent->keyboard.keycode == gameControls.down)
        {
            gameControls.controlFlags |= CONTROL_DOWN_FLAG;
        }

        if (allegroEvent->keyboard.keycode == gameControls.track)
        {
            gameControls.controlFlags |= CONTROL_TRACK_FLAG;
        }

        if (allegroEvent->keyboard.keycode == gameControls.exit)
        {
            gameControls.controlFlags |= CONTROL_EXIT_FLAG;
        }
    }
    else if (allegroEvent->type == ALLEGRO_EVENT_KEY_UP)
    {
        if (allegroEvent->keyboard.keycode == gameControls.left)
        {
            gameControls.controlFlags &= ~CONTROL_LEFT_FLAG;
        }

        if (allegroEvent->keyboard.keycode == gameControls.right)
        {
            gameControls.controlFlags &= ~CONTROL_RIGHT_FLAG;
        }

        if (allegroEvent->keyboard.keycode == gameControls.up)
        {
            gameControls.controlFlags &= ~CONTROL_UP_FLAG;
        }

        if (allegroEvent->keyboard.keycode == gameControls.down)
        {
            gameControls.controlFlags &= ~CONTROL_DOWN_FLAG;
        }

        if (allegroEvent->keyboard.keycode == gameControls.track)
        {
            gameControls.controlFlags &= ~CONTROL_TRACK_FLAG;
        }

        if (allegroEvent->keyboard.keycode == gameControls.exit)
        {
            gameControls.controlFlags &= ~CONTROL_EXIT_FLAG;
        }
    }
    else if (allegroEvent->type == ALLEGRO_EVENT_DISPLAY_CLOSE)
    {
        // Update the exit flag to display the exit dialog on clicking the close button of the window.
        gameControls.controlFlags |= CONTROL_EXIT_FLAG;
    }
}

void saveControls(ALLEGRO_CONFIG* config, ALLEGRO_PATH* configPath)
{
    // Setting control values in the game config file.
    static u8 keyText[4];
    convertNumberToString(gameControls.left, keyText);
    al_set_config_value(config, NULL, "controls_left", keyText);

    convertNumberToString(gameControls.right, keyText);
    al_set_config_value(config, NULL, "controls_right", keyText);

    convertNumberToString(gameControls.up, keyText);
    al_set_config_value(config, NULL, "controls_up", keyText);

    convertNumberToString(gameControls.down, keyText);
    al_set_config_value(config, NULL, "controls_down", keyText);

    convertNumberToString(gameControls.track, keyText);
    al_set_config_value(config, NULL, "controls_track", keyText);

    convertNumberToString(gameControls.exit, keyText);
    al_set_config_value(config, NULL, "controls_exit", keyText);

    // Write out the config file with the update controls.
    al_save_config_file(al_path_cstr(configPath, '/'), config);
}