#include "Hud.h"

// Indicates if the hud is redrawn on the screen.
u8 hudRedraw = TRUE;

// X position of the first part of the hud.
#define HUD_X_POSITION_ 0

// X position of the second part of the hud.
#define HUD_X_POSITION_TWO_ 64

// Y position of the hud.
#define HUD_Y_POSITION_ 176

// Width of the first part of the hud.
#define HUD_WIDTH_ONE_ 64

// Width of the second part of the hud.
#define HUD_WIDTH_TWO_ 16

// Height of the hud.
#define HUD_HEIGHT_ 24

// X position of the game score.
#define HUD_SCORE_START_ 0

// X position for level count down.
#define COUNT_DOWN_START_ 155

void drawHud()
{
    if (hudRedraw)
    {
        static u8 hudText[6];

        al_draw_filled_rectangle(HUD_X_POSITION_, HUD_Y_POSITION_ * scaleFactor, (HUD_WIDTH_ONE_ + HUD_WIDTH_TWO_) * 4 * scaleFactor, (HUD_Y_POSITION_ + HUD_HEIGHT_) * scaleFactor, al_map_rgb(0, 255, 255));
        al_flip_display();

        // Draw the current game score at the bottom left.
        drawScoreAllegro(players[0].score, HUD_SCORE_START_, 4 + HUD_Y_POSITION_, scaleFactor, al_map_rgb(0, 0, 128));

        // Draw the time before the train will start.
        convertNumberToString(trainCountDown, hudText);
        drawString(COUNT_DOWN_START_, 4 + HUD_Y_POSITION_, scaleFactor, hudText, al_map_rgb(0, 0, 128));

        // Draw the current score for the second player (if implemented).
        if (playerCount == 2)
        {
            drawScoreAllegro(players[1].score, HUD_SCORE_START_ + 180, 4 + HUD_Y_POSITION_, scaleFactor, al_map_rgb(0, 0, 128));
        }

        // Hud will not redraw until hudRedraw is set to true for the next update.
        hudRedraw = FALSE;

        // Draws the next pieces that the player(s) can use on the hud.
        drawNextPieces(FALSE);
    }
}

void drawNextPieces()
{
    u8 i = 0;

    for (i = 0; i < 5; ++i)
    {
        al_draw_scaled_bitmap(allegroTrackSprites[players[0].nextPieces[i]], 0, 0, TILE_WIDTH_BYTES * 2, TILE_HEIGHT, (10 + i * TILE_WIDTH_BYTES + i) * 4 * scaleFactor, (4 + HUD_Y_POSITION_) * scaleFactor, TILE_WIDTH_BYTES * 4 * scaleFactor, TILE_HEIGHT * scaleFactor, 0);
    }

    // Draw the score for the second player if implemented.
    // There would only ever be two players on one machine so 2 is valid for LAN with more than 2 players.
    if (playerCount == 2)
    {
        for (i = 0; i < 5; ++i)
        {
            al_draw_scaled_bitmap(allegroTrackSprites[players[1].nextPieces[i]], 0, 0, TILE_WIDTH_BYTES * 2, TILE_HEIGHT, (55 + i * TILE_WIDTH_BYTES + i) * 4 * scaleFactor, (4 + HUD_Y_POSITION_) * scaleFactor, TILE_WIDTH_BYTES * 4 * scaleFactor, TILE_HEIGHT * scaleFactor, 0);
        }
    }
}