#ifndef GAMETYPES_H
#define GAMETYPES_H

// Boolean true value 1.
#define TRUE 1

// Boolean false value 0.
#define FALSE 0

// The number of levels in the game.
#define LEVEL_COUNT 3

// The number of cells in the map grid.
#define MAP_CELL_COUNT 1980

// The amount to scale the sprites based on screen resolution.
extern unsigned char scaleFactor;

// Cpctelera defines shortcut types in types.h that we are defining here for when using allegro.
typedef unsigned char       u8;
typedef signed char         i8;
typedef unsigned short      u16;
typedef signed short        i16;
typedef unsigned long      u32;
typedef signed long        i32;
typedef unsigned long long u64;
typedef signed long long   i64;
typedef float              f32;

// Ready to start the level.
#define LEVEL_READY 0

// The level has been completed successfully.
#define LEVEL_COMPLETE 1

// The level has been exited via the exit dialog.
#define LEVEL_EXIT 2

// The player has died or exited the level.
#define LEVEL_DEATH 3

// All the levels in the game have been completed.
#define LEVEL_GAME_COMPLETE 4

// Number of tiles that make up the screen vertically.
#define SCREEN_TILES_Y 11

// Number of tiles that make the screen horizontally.
#define SCREEN_TILES_X 20

// Height of a tile on screen.
#define TILE_HEIGHT 16

// Width of a tile on screen.
#define TILE_WIDTH_BYTES 4

// Number of tiles that make up the level vertically.
#define MAP_TILES_Y 33

// Number of tiles that make up the level horizontally.
#define MAP_TILES_X 60

// The possible bits that the cell graphic could be in.
#define CELL_GFX_RANGE 0x1F

// Flag indicating the cell is a map feature.
#define CELL_MAP_FEATURE_FLAG 0x20

// Flag indicating the cell is an environment cell.
#define CELL_ENVIRONMENT_FLAG 0x40

// The number of pieces visible to the player.
#define NEXT_PIECE_COUNT 5

// The maximum number of players in the game 
// (normally one, possibly two for same machine coop, but even more for LAN).
#define MAX_PLAYER_COUNT 2

// Right direction.
#define DIRECTION_RIGHT 0

// Left direction.
#define DIRECTION_LEFT 1

// Down direction.
#define DIRECTION_DOWN 2

// Up direction.
#define DIRECTION_UP 3

// The number of possible directions.
#define DIRECTION_COUNT 4

// 0 = RIGHT ( 1, 0)
// 1 = LEFT  (-1, 0)
// 2 = DOWN  ( 0, 1)
// 3 = UP    ( 0,-1)
extern const i8 directionX[DIRECTION_COUNT];
extern const i8 directionY[DIRECTION_COUNT];

#endif