#ifndef GAMESTATE_H
#define GAMESTATE_H

#include <allegro5/allegro.h>
#include "GameTypes.h"

// Indicates if the game is currently running within the game loop.
extern u8 gameRunning;

// The score for the whole game session including the current level.
extern u16 score;

// Indicates the state of the level (or game) and whether it has ended (including success or failure).
extern u8 levelState;

// The number of player playing the game.
extern u8 playerCount;

// The amount of time to wait for the train to start.
extern u8 trainCountDown;

// The speed that the train moves.
extern u8 trainSpeed;

// The colour of the train colour sprite.
extern u8 trainColour;

// Resets state values for the start of a new game session.
void resetGameSessionState(ALLEGRO_CONFIG* config);

#endif