#include "GameState.h"

// Indicates the state of the level (or game) and whether it has ended (including success or failure).
u8 levelState = LEVEL_READY;

// Indicates if the game is currently running within the game loop.
u8 gameRunning = FALSE;

// The number of player playing the game.
u8 playerCount = 2;

// The amount of time to wait for the train to start.
u8 trainCountDown = 0;

// The speed that the train moves.
u8 trainSpeed = 10;

// The colour of the train colour sprite.
u8 trainColour = 0;

void resetGameSessionState(ALLEGRO_CONFIG* config)
{
    if (al_get_config_value(config, NULL, "train_colour") != NULL)
    {
        trainColour = atoi(al_get_config_value(config, NULL, "train_colour"));
    }
    else
    {
        trainColour = 0;
    }

    // Make sure that it does not go out of range.
    if (trainColour > 4)
    {
        trainColour = 0;
    }

    trainSpeed = 10;
    playerCount = 1;
    levelState = LEVEL_READY;
}