#ifndef GAME_H
#define GAME_H

#include <allegro5/allegro.h>
#include "GameState.h"
#include "GameTypes.h"
#include "Dialog.h"
#include "Hud.h"
#include "Keys.h"
#include "Map.h"
#include "MapManager.h"
#include "Train.h"

// Runs the full game session and manages the levels in the game.
void runGameSession(ALLEGRO_CONFIG* config);

// Runs the game and the game loop with allegro.
void runGameAllegro();

// Read input from the player from the allegro event.
void readInput(ALLEGRO_EVENT_QUEUE* eventQueue, ALLEGRO_EVENT* allegroEvent);

// Displays the contents of the game on the screen as it changes.
void drawGame();

// This is where the processing of all the game logic happens.
void gameLogic();

#endif