#include "Dialog.h"

// The width of the exit dialog.
#define EXIT_DIALOG_WIDTH_ 100

// The height of the exit dialog.
#define EXIT_DIALOG_HEIGHT_ 32

// The x position that the dialog is drawn from.
#define DIALOG_X_ 108

// The y position that the dialog is drawn from.
#define DIALOG_Y_ 44

// The y position that dialog text starts from.
#define DIALOG_Y_TEXT_ 53

// The x position that dialog text starts from.
#define DIALOG_X_TEXT_ 120

u8 exitDialogAllegro(ALLEGRO_EVENT_QUEUE* eventQueue, ALLEGRO_EVENT* allegroEvent)
{
    al_draw_filled_rectangle(DIALOG_X_ * scaleFactor, DIALOG_Y_ * scaleFactor, (DIALOG_X_ + EXIT_DIALOG_WIDTH_) * scaleFactor, (DIALOG_Y_ + EXIT_DIALOG_HEIGHT_) * scaleFactor, al_map_rgb(78, 9, 28));
    drawString(DIALOG_X_TEXT_, DIALOG_Y_TEXT_, scaleFactor, "EXIT", al_map_rgb(255, 255, 255));
    drawString(DIALOG_X_TEXT_ + 40, DIALOG_Y_TEXT_, scaleFactor, "Y     OR     N", al_map_rgb(255, 255, 255));
    al_flip_display();

    while (1)
    {
        al_wait_for_event(eventQueue, allegroEvent);

        if (allegroEvent->type == ALLEGRO_EVENT_KEY_DOWN)
        {
            if (allegroEvent->keyboard.keycode == ALLEGRO_KEY_Y)
            {
                // Clear game controls to prevent exit dialog begin shown again.
                gameControls.controlFlags = 0;

                return TRUE;
            }
            else if (allegroEvent->keyboard.keycode == ALLEGRO_KEY_N)
            {
                // Clear game controls to prevent exit dialog begin shown again.
                gameControls.controlFlags = 0;

                return FALSE;
            }
        }
    }
}

void crashDialog(ALLEGRO_EVENT_QUEUE* eventQueue, ALLEGRO_EVENT* allegroEvent)
{
    al_draw_filled_rectangle(DIALOG_X_ * scaleFactor, DIALOG_Y_ * scaleFactor, (DIALOG_X_ + EXIT_DIALOG_WIDTH_) * scaleFactor, (DIALOG_Y_ + EXIT_DIALOG_HEIGHT_) * scaleFactor, al_map_rgb(78, 9, 28));
    drawString(DIALOG_X_TEXT_ + 16, DIALOG_Y_TEXT_, scaleFactor, "TRAIN CRASH", al_map_rgb(255, 255, 255));
    al_flip_display();

    getKeyAllegro(&eventQueue);
}

void levelCompleteDialog(ALLEGRO_EVENT_QUEUE* eventQueue, ALLEGRO_EVENT* allegroEvent)
{
    al_draw_filled_rectangle(DIALOG_X_ * scaleFactor, DIALOG_Y_ * scaleFactor, (DIALOG_X_ + EXIT_DIALOG_WIDTH_) * scaleFactor, (DIALOG_Y_ + EXIT_DIALOG_HEIGHT_) * scaleFactor, al_map_rgb(78, 9, 28));
    drawString(DIALOG_X_TEXT_ + 8, DIALOG_Y_TEXT_, scaleFactor, "LEVEL COMPLETE", al_map_rgb(255, 255, 255));
    al_flip_display();

    getKeyAllegro(&eventQueue);
}