using UnityEngine;
using System.Collections.Generic;

public class SpawnRoomInCart : MonoBehaviour
{
    public List<GameObject> roomLayoutPrefabs;

    public List<EnemyHealth> enemies = new List<EnemyHealth>();

    [SerializeField] GameObject barrier;


    public void SpawnRoom()
    {
        if (roomLayoutPrefabs == null || roomLayoutPrefabs.Count == 0)
        {
            Debug.LogError("No RoomLayout prefabs assigned.");
            return;
        }

        int randomIndex = Random.Range(0, roomLayoutPrefabs.Count);
        GameObject roomLayoutPrefab = roomLayoutPrefabs[randomIndex];

        Vector3 spawnPosition = transform.position;
        GameObject roomLayout = Instantiate(roomLayoutPrefab, spawnPosition, Quaternion.identity);

        roomLayout.transform.SetParent(transform);

        enemies = new List<EnemyHealth>(roomLayout.GetComponentsInChildren<EnemyHealth>());
    }

    private void Update()
    {
        enemies.RemoveAll(item => item == null);

        if (enemies.Count == 0)
        {
            barrier.SetActive(false);
        }
        else
        {

            barrier.SetActive(true);
        }


    }

}
