using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public enum ItemType
{
    MaxHPUpgrade,
    MaxAmmoUpgrade,
}

public class ShopItem : MonoBehaviour
{

    public int price;
    public string itemName;

    bool inRange = false;

    bool canBuy = true;

    PlayerHealth playerHealth;
    PlayerStats playerStats;

    public ItemType itemType;


    private void Awake()
    {
        playerHealth = FindObjectOfType<PlayerHealth>();
        playerStats = FindObjectOfType<PlayerStats>();
    }


    void Update()
    {
        if (inRange && Input.GetKeyDown(KeyCode.E) && canBuy)
        {
            playerStats.DecreaseCash(price);
            if (itemType == ItemType.MaxHPUpgrade)
            {
                playerHealth.IncreaseMaxHealth(1);
            }
            else if (itemType == ItemType.MaxAmmoUpgrade)
            {
                playerStats.IncreaseMaxAmmo(1);
            }

            Destroy(gameObject);
            PromptShower.instance.HidePrompt();
        }

    }

    private void OnTriggerEnter2D(Collider2D other)
    {
        if (other.CompareTag("Player"))
        {
            inRange = true;
            PromptShower.instance.ShowPrompt("Press E to buy " + itemName + " for " + price + " coins");
        }
    }

    private void OnTriggerExit2D(Collider2D other)
    {
        if (other.CompareTag("Player"))
        {
            inRange = false;
            PromptShower.instance.HidePrompt();
        }
    }
}
