using UnityEngine;

public class GunRotation : MonoBehaviour
{
    public Transform player;
    public Transform playerSprite;

    private void Update()
    {
        RotateGun();
    }

    private void RotateGun()
    {
        Vector3 mousePosition = Camera.main.ScreenToWorldPoint(Input.mousePosition);
        Vector3 direction = mousePosition - player.position;

        float angle = Mathf.Atan2(direction.y, direction.x) * Mathf.Rad2Deg;

        bool facingRight = playerSprite.localScale.x > 0;

        if (facingRight)
        {
            transform.rotation = Quaternion.Euler(new Vector3(0, 0, angle));
        }
        else
        {
            transform.rotation = Quaternion.Euler(new Vector3(0, 0, angle + 180));
        }
    }
}
